/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.util.logging.Level;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.compiere.grid.ed.VOvrCaret;
import org.compiere.util.CLogger;

public final class MDocString
extends PlainDocument
implements CaretListener {
    private static final long serialVersionUID = -1714284669663890694L;
    private String m_VFormat;
    private String m_mask;
    private int m_fieldLength;
    private int m_maxLength;
    private JTextComponent m_tc;
    private int m_lastDot = 0;
    private static final char SPACE = ' ';
    private static final char SPACE_IND = '_';
    private static CLogger log = CLogger.getCLogger(MDocString.class);

    public MDocString(String VFormat, int fieldLength, JTextComponent tc) {
        this.m_fieldLength = fieldLength;
        this.setFormat(VFormat);
        this.m_tc = tc;
        if (tc != null) {
            this.m_tc.addCaretListener(this);
        }
    }

    public final void setFormat(String VFormat) {
        this.m_VFormat = VFormat;
        if (this.m_VFormat == null) {
            this.m_VFormat = "";
        }
        this.m_mask = this.m_VFormat;
        this.m_maxLength = this.m_fieldLength;
        if (this.m_VFormat.length() == 0) {
            return;
        }
        log.fine(VFormat);
        if (this.m_maxLength > this.m_VFormat.length()) {
            this.m_maxLength = this.m_VFormat.length();
        }
        this.m_mask = this.m_mask.replace('c', ' ');
        this.m_mask = this.m_mask.replace('C', ' ');
        this.m_mask = this.m_mask.replace('a', ' ');
        this.m_mask = this.m_mask.replace('A', ' ');
        this.m_mask = this.m_mask.replace('l', ' ');
        this.m_mask = this.m_mask.replace('L', ' ');
        this.m_mask = this.m_mask.replace('o', ' ');
        this.m_mask = this.m_mask.replace('O', ' ');
        this.m_mask = this.m_mask.replace('0', ' ');
        this.m_mask = this.m_mask.replace('9', ' ');
        this.m_mask = this.m_mask.replace('Z', ' ');
        if (this.m_tc == null || this.m_tc.getCaret() instanceof VOvrCaret) {
            return;
        }
        this.m_tc.setCaret(new VOvrCaret());
    }

    @Override
    public void insertString(int offset, String string, AttributeSet attr) throws BadLocationException {
        if (this.m_VFormat.length() == 0 ? this.getLength() + string.length() > this.m_maxLength : offset >= this.m_maxLength) {
            return;
        }
        if (this.m_VFormat.length() == 0 || string.length() != 1) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Offset=" + offset + " String=" + string);
            }
            super.insertString(offset, string, attr);
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Offset=" + offset + ", String=" + string + ", MaxLength=" + this.m_maxLength + ", Format=" + this.m_VFormat + ", Mask=" + this.m_mask + ", Text=" + this.getText() + ", Length=" + this.getText().length());
        }
        String text = this.getText();
        if (this.m_VFormat.length() != text.length()) {
            char[] result = this.m_mask.toCharArray();
            int i = 0;
            while (i < result.length) {
                if (result[i] == ' ' && text.length() > i) {
                    result[i] = text.charAt(i);
                } else if (result[i] == '_') {
                    result[i] = 32;
                }
                ++i;
            }
            super.remove(0, text.length());
            super.insertString(0, new String(result), attr);
            this.m_tc.setCaretPosition(offset);
            text = this.getText();
        }
        if (offset + 1 < text.length() && this.m_mask.charAt(offset + 1) != ' ' && offset + 2 < this.getText().length()) {
            this.m_tc.setCaretPosition(offset + 2);
        }
        if (this.m_mask.charAt(offset) != ' ') {
            if (offset + 1 == this.m_mask.length()) {
                return;
            }
            this.m_tc.setCaretPosition(++offset + 1);
        }
        char c = string.charAt(0);
        char cmd = this.m_VFormat.charAt(offset);
        if (log.isLoggable(Level.FINE)) {
            log.fine("char=" + c + ", cmd=" + cmd);
        }
        switch (cmd) {
            case 'c': {
                if (Character.isLetter(c) || Character.isDigit(c) || Character.isSpaceChar(c)) break;
                return;
            }
            case 'C': {
                if (Character.isLetter(c) || Character.isDigit(c) || Character.isSpaceChar(c)) {
                    string = string.toUpperCase();
                    break;
                }
                return;
            }
            case 'a': {
                if (Character.isLetter(c) || Character.isDigit(c)) break;
                return;
            }
            case 'A': {
                if (Character.isLetter(c) || Character.isDigit(c)) {
                    string = string.toUpperCase();
                    break;
                }
                return;
            }
            case 'l': {
                if (Character.isLetter(c)) break;
                return;
            }
            case 'L': {
                if (!Character.isLetter(c)) {
                    return;
                }
                string = string.toUpperCase();
                break;
            }
            case 'o': {
                if (Character.isLetter(c) || Character.isSpaceChar(c)) break;
                return;
            }
            case 'O': {
                if (Character.isLetter(c) || Character.isSpaceChar(c)) {
                    string = string.toUpperCase();
                    break;
                }
                return;
            }
            case '9': {
                if (Character.isDigit(c) || Character.isSpaceChar(c)) break;
                return;
            }
            case '0': {
                if (Character.isDigit(c)) break;
                return;
            }
            case ' ': {
                break;
            }
            case 'Z': {
                string = string.toUpperCase();
                break;
            }
            default: {
                return;
            }
        }
        super.remove(offset, 1);
        super.insertString(offset, string, attr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void remove(int offset, int length) throws BadLocationException {
        if (this.m_VFormat.length() == 0 || length != 1) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Offset=" + offset + " Length=" + length);
            }
            super.remove(offset, length);
            return;
        }
        if (offset == 0) {
            if (length != this.m_mask.length()) return;
            super.remove(offset, length);
            return;
        }
        if (offset - 1 >= 0 && this.m_mask.charAt(offset - 1) != ' ') {
            if (offset - 2 < 0) return;
            this.m_tc.setCaretPosition(offset - 2);
            return;
        } else {
            this.m_tc.setCaretPosition(offset - 1);
        }
    }

    private String getText() {
        String str = "";
        try {
            str = this.getContent().getString(0, this.getContent().length() - 1);
        }
        catch (Exception e) {
            str = "";
        }
        return str;
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (this.m_VFormat.length() == 0 || this.m_VFormat.equals(this.m_mask)) {
            return;
        }
        if (e.getDot() != e.getMark()) {
            this.m_lastDot = e.getDot();
            return;
        }
        if (e.getDot() + 1 > this.m_mask.length() || this.m_mask.charAt(e.getDot()) == ' ') {
            this.m_lastDot = e.getDot();
            return;
        }
        int newDot = -1;
        newDot = this.m_lastDot > e.getDot() ? e.getDot() - 1 : e.getDot() + 1;
        if (e.getDot() == 0) {
            newDot = 1;
        } else if (e.getDot() == this.m_mask.length() - 1) {
            newDot = e.getDot() - 1;
        }
        this.m_lastDot = e.getDot();
        if (newDot >= 0 && newDot < this.getText().length()) {
            this.m_tc.setCaretPosition(newDot);
        }
    }
}

