/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.MBPartnerInfo;
import org.compiere.model.PO;
import org.compiere.pos.PosBasePanel;
import org.compiere.pos.PosQuery;
import org.compiere.pos.PosTable;
import org.compiere.pos.PosTextField;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class QueryBPartner
extends PosQuery {
    private static final long serialVersionUID = -4500636033505855695L;
    private PosTextField f_value;
    private PosTextField f_name;
    private PosTextField f_contact;
    private PosTextField f_email;
    private PosTextField f_phone;
    private CTextField f_city;
    private int m_C_BPartner_ID;
    private CButton f_refresh;
    private CButton f_ok;
    private CButton f_cancel;
    private static CLogger log = CLogger.getCLogger(QueryBPartner.class);
    private static ColumnInfo[] s_layout = new ColumnInfo[]{new ColumnInfo(" ", "C_BPartner_ID", IDColumn.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"Value"), "Value", String.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"Name"), "Name", String.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"Email"), "Email", String.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"Phone"), "Phone", String.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"Postal"), "Postal", String.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"City"), "City", String.class)};
    private static String s_sqlFrom = "RV_BPartner";
    private static String s_sqlWhere = "IsActive='Y'";

    public QueryBPartner(PosBasePanel posPanel) {
        super(posPanel);
    }

    @Override
    protected void init() {
        CPanel panel = new CPanel();
        panel.setLayout((LayoutManager)new MigLayout("fill"));
        this.getContentPane().add(panel);
        this.northPanel = new CPanel((LayoutManager)new MigLayout("fill", "", "[50][50][]"));
        panel.add((Component)this.northPanel, "north");
        this.northPanel.setBorder(new TitledBorder(Msg.getMsg((Properties)this.p_ctx, (String)"Query")));
        CLabel lvalue = new CLabel(Msg.translate((Properties)this.p_ctx, (String)"Value"));
        this.northPanel.add((Component)lvalue, " growy");
        this.f_value = new PosTextField("", this.p_posPanel, this.p_pos.getOSK_KeyLayout_ID());
        lvalue.setLabelFor(this.f_value);
        this.northPanel.add((Component)this.f_value, "h 30, w 200");
        this.f_value.addActionListener(this);
        CLabel lcontact = new CLabel(Msg.translate((Properties)this.p_ctx, (String)"Contact"));
        this.northPanel.add((Component)lcontact, " growy");
        this.f_contact = new PosTextField("", this.p_posPanel, this.p_pos.getOSK_KeyLayout_ID());
        lcontact.setLabelFor(this.f_contact);
        this.northPanel.add((Component)this.f_contact, "h 30, w 200");
        this.f_contact.addActionListener(this);
        CLabel lphone = new CLabel(Msg.translate((Properties)this.p_ctx, (String)"Phone"));
        this.northPanel.add((Component)lphone, " growy");
        this.f_phone = new PosTextField("", this.p_posPanel, this.p_pos.getOSK_KeyLayout_ID());
        lphone.setLabelFor(this.f_phone);
        this.northPanel.add((Component)this.f_phone, "h 30, w 200, wrap");
        this.f_phone.addActionListener(this);
        CLabel lname = new CLabel(Msg.translate((Properties)this.p_ctx, (String)"Name"));
        this.northPanel.add((Component)lname, " growy");
        this.f_name = new PosTextField("", this.p_posPanel, this.p_pos.getOSK_KeyLayout_ID());
        lname.setLabelFor(this.f_name);
        this.northPanel.add((Component)this.f_name, "h 30, w 200");
        this.f_name.addActionListener(this);
        CLabel lemail = new CLabel(Msg.translate((Properties)this.p_ctx, (String)"Email"));
        this.northPanel.add((Component)lemail, " growy");
        this.f_email = new PosTextField("", this.p_posPanel, this.p_pos.getOSK_KeyLayout_ID());
        lemail.setLabelFor(this.f_email);
        this.northPanel.add((Component)this.f_email, "h 30, w 200");
        this.f_email.addActionListener(this);
        CLabel lcity = new CLabel(Msg.translate((Properties)this.p_ctx, (String)"City"));
        this.northPanel.add((Component)lcity, " growy");
        this.f_city = new CTextField(10);
        lcity.setLabelFor(this.f_city);
        this.northPanel.add((Component)this.f_city, "h 30, w 200");
        this.f_city.addActionListener(this);
        this.f_refresh = this.createButtonAction("Refresh", KeyStroke.getKeyStroke(116, 0));
        this.northPanel.add((Component)this.f_refresh, "w 50!, h 50!, wrap, alignx trailing");
        this.f_up = this.createButtonAction("Previous", KeyStroke.getKeyStroke(38, 0));
        this.northPanel.add((Component)this.f_up, "w 50!, h 50!, span, split 4");
        this.f_down = this.createButtonAction("Next", KeyStroke.getKeyStroke(40, 0));
        this.northPanel.add((Component)this.f_down, "w 50!, h 50!");
        this.f_ok = this.createButtonAction("Ok", KeyStroke.getKeyStroke(10, 0));
        this.northPanel.add((Component)this.f_ok, "w 50!, h 50!");
        this.f_cancel = this.createButtonAction("Cancel", KeyStroke.getKeyStroke(27, 0));
        this.northPanel.add((Component)this.f_cancel, "w 50!, h 50!");
        this.m_table = new PosTable();
        String sql = String.valueOf(this.m_table.prepareTable(s_layout, s_sqlFrom, s_sqlWhere, false, "RV_BPartner")) + " ORDER BY Value";
        this.m_table.addMouseListener(this);
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.enableButtons();
        this.centerScroll = new CScrollPane(this.m_table);
        panel.add((Component)this.centerScroll, "growx, growy");
        this.m_table.growScrollbars();
        panel.setPreferredSize(new Dimension(800, 600));
        this.f_value.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (log.isLoggable(Level.INFO)) {
            log.info(e.getActionCommand());
        }
        if ("Refresh".equals(e.getActionCommand()) || e.getSource() == this.f_value || e.getSource() == this.f_name) {
            this.setResults(MBPartnerInfo.find((Properties)this.p_ctx, (String)this.f_value.getText(), (String)this.f_name.getText(), null, (String)this.f_email.getText(), (String)this.f_phone.getText(), (String)this.f_city.getText()));
            return;
        }
        if ("Reset".equals(e.getActionCommand())) {
            this.reset();
            return;
        }
        if ("Previous".equalsIgnoreCase(e.getActionCommand())) {
            int rows = this.m_table.getRowCount();
            if (rows == 0) {
                return;
            }
            int row = this.m_table.getSelectedRow();
            if (--row < 0) {
                row = 0;
            }
            this.m_table.getSelectionModel().setSelectionInterval(row, row);
            return;
        }
        if ("Next".equalsIgnoreCase(e.getActionCommand())) {
            int rows = this.m_table.getRowCount();
            if (rows == 0) {
                return;
            }
            int row = this.m_table.getSelectedRow();
            if (++row >= rows) {
                row = rows - 1;
            }
            this.m_table.getSelectionModel().setSelectionInterval(row, row);
            return;
        }
        this.close();
    }

    public void setResults(MBPartnerInfo[] results) {
        this.m_table.loadTable((PO[])results);
        this.enableButtons();
    }

    @Override
    protected void enableButtons() {
        Integer ID;
        boolean enabled;
        this.m_C_BPartner_ID = -1;
        int row = this.m_table.getSelectedRow();
        boolean bl = enabled = row != -1;
        if (enabled && (ID = this.m_table.getSelectedRowKey()) != null) {
            this.m_C_BPartner_ID = ID;
        }
        this.f_ok.setEnabled(enabled);
        if (log.isLoggable(Level.FINE)) {
            log.fine("C_BPartner_ID=" + this.m_C_BPartner_ID);
        }
    }

    @Override
    protected void close() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("C_BPartner_ID=" + this.m_C_BPartner_ID);
        }
        if (this.m_C_BPartner_ID > 0) {
            this.p_posPanel.f_order.setC_BPartner_ID(this.m_C_BPartner_ID);
        } else {
            this.p_posPanel.f_order.setC_BPartner_ID(0);
        }
        this.dispose();
    }

    @Override
    public void reset() {
        this.f_value.setText(null);
        this.f_name.setText(null);
        this.f_contact.setText(null);
        this.f_email.setText(null);
        this.f_phone.setText(null);
        this.f_city.setText(null);
        this.setResults(new MBPartnerInfo[0]);
    }
}

