/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.compiere.grid.ed.VDate;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.pos.PosBasePanel;
import org.compiere.pos.PosQuery;
import org.compiere.pos.PosTable;
import org.compiere.pos.PosTextField;
import org.compiere.swing.CButton;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class QueryTicket
extends PosQuery {
    private static final long serialVersionUID = 1487067464540688770L;
    private PosTextField f_documentno;
    private VDate f_date;
    private int m_c_order_id;
    private CCheckBox f_processed;
    private CButton f_refresh;
    private CButton f_ok;
    private CButton f_cancel;
    private static ColumnInfo[] s_layout = new ColumnInfo[]{new ColumnInfo(" ", "C_Order_ID", IDColumn.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo"), "DocumentNo", String.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"TotalLines"), "TotalLines", BigDecimal.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"GrandTotal"), "GrandTotal", BigDecimal.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"), "Name", String.class), new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)"Processed"), "Processed", Boolean.class)};

    public QueryTicket(PosBasePanel posPanel) {
        super(posPanel);
    }

    @Override
    protected void init() {
        CPanel panel = new CPanel();
        panel.setLayout((LayoutManager)new MigLayout("fill"));
        this.getContentPane().add(panel);
        this.northPanel = new CPanel((LayoutManager)new MigLayout("fill", "", "[50][50][]"));
        panel.add((Component)this.northPanel, "north");
        this.northPanel.setBorder(new TitledBorder(Msg.getMsg((Properties)this.p_ctx, (String)"Query")));
        CLabel ldoc = new CLabel(Msg.translate((Properties)this.p_ctx, (String)"DocumentNo"));
        this.northPanel.add((Component)ldoc, " growy");
        this.f_documentno = new PosTextField("", this.p_posPanel, this.p_pos.getOSK_KeyLayout_ID());
        ldoc.setLabelFor(this.f_documentno);
        this.northPanel.add((Component)this.f_documentno, "h 30, w 200");
        this.f_documentno.addActionListener(this);
        CLabel ldate = new CLabel(Msg.translate((Properties)this.p_ctx, (String)"DateOrdered"));
        this.northPanel.add((Component)ldate, "growy");
        this.f_date = new VDate();
        this.f_date.setValue(Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date"));
        ldate.setLabelFor(this.f_date);
        this.northPanel.add((Component)this.f_date, "h 30, w 200");
        this.f_date.addActionListener(this);
        this.f_processed = new CCheckBox(Msg.translate((Properties)this.p_ctx, (String)"Processed"));
        this.f_processed.setSelected(false);
        this.northPanel.add((Component)this.f_processed, "");
        this.f_refresh = this.createButtonAction("Refresh", KeyStroke.getKeyStroke(116, 0));
        this.northPanel.add((Component)this.f_refresh, "w 50!, h 50!, wrap, alignx trailing");
        this.f_up = this.createButtonAction("Previous", KeyStroke.getKeyStroke(38, 0));
        this.northPanel.add((Component)this.f_up, "w 50!, h 50!, span, split 4");
        this.f_down = this.createButtonAction("Next", KeyStroke.getKeyStroke(40, 0));
        this.northPanel.add((Component)this.f_down, "w 50!, h 50!");
        this.f_ok = this.createButtonAction("Ok", KeyStroke.getKeyStroke(10, 0));
        this.northPanel.add((Component)this.f_ok, "w 50!, h 50!");
        this.f_cancel = this.createButtonAction("Cancel", KeyStroke.getKeyStroke(27, 0));
        this.northPanel.add((Component)this.f_cancel, "w 50!, h 50!");
        this.m_table = new PosTable();
        String sql = String.valueOf(this.m_table.prepareTable(s_layout, "C_Order", "C_POS_ID = " + this.p_pos.getC_POS_ID(), false, "C_Order")) + " ORDER BY Margin, QtyAvailable";
        this.m_table.addMouseListener(this);
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.enableButtons();
        this.centerScroll = new CScrollPane(this.m_table);
        panel.add((Component)this.centerScroll, "growx, growy");
        this.m_table.growScrollbars();
        panel.setPreferredSize(new Dimension(800, 600));
        this.f_documentno.requestFocus();
        this.pack();
        this.setResults(this.p_ctx, this.f_processed.isSelected(), this.f_documentno.getText(), this.f_date.getTimestamp());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (log.isLoggable(Level.INFO)) {
            log.info("PosQueryProduct.actionPerformed - " + e.getActionCommand());
        }
        if ("Refresh".equals(e.getActionCommand()) || e.getSource() == this.f_processed || e.getSource() == this.f_documentno || e.getSource() == this.f_date) {
            this.setResults(this.p_ctx, this.f_processed.isSelected(), this.f_documentno.getText(), this.f_date.getTimestamp());
            return;
        }
        if ("Reset".equals(e.getActionCommand())) {
            this.reset();
            return;
        }
        if ("Previous".equalsIgnoreCase(e.getActionCommand())) {
            int rows = this.m_table.getRowCount();
            if (rows == 0) {
                return;
            }
            int row = this.m_table.getSelectedRow();
            if (--row < 0) {
                row = 0;
            }
            this.m_table.getSelectionModel().setSelectionInterval(row, row);
            return;
        }
        if ("Next".equalsIgnoreCase(e.getActionCommand())) {
            int rows = this.m_table.getRowCount();
            if (rows == 0) {
                return;
            }
            int row = this.m_table.getSelectedRow();
            if (++row >= rows) {
                row = rows - 1;
            }
            this.m_table.getSelectionModel().setSelectionInterval(row, row);
            return;
        }
        if ("Cancel".equalsIgnoreCase(e.getActionCommand())) {
            this.dispose();
            return;
        }
        this.close();
    }

    @Override
    public void reset() {
        this.f_processed.setSelected(false);
        this.f_documentno.setText(null);
        this.f_date.setValue(Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date"));
        this.setResults(this.p_ctx, this.f_processed.isSelected(), this.f_documentno.getText(), this.f_date.getTimestamp());
    }

    public void setResults(Properties ctx, boolean processed, String doc, Timestamp date) {
        String sql = "";
        try {
            sql = "SELECT o.C_Order_ID, o.DocumentNo, o.TotalLines, o.GrandTotal, b.Name, o.Processed FROM C_Order o INNER JOIN C_BPartner b ON o.C_BPartner_ID=b.C_BPartner_ID WHERE o.C_POS_ID = " + this.p_pos.getC_POS_ID();
            sql = String.valueOf(sql) + " AND o.Processed = " + (processed ? "'Y' " : "'N' ");
            if (doc != null && !doc.equalsIgnoreCase("")) {
                sql = String.valueOf(sql) + " AND o.DocumentNo = '" + doc + "'";
            }
            if (date != null) {
                sql = String.valueOf(sql) + " AND o.DateOrdered = ? Order By o.DocumentNo DESC";
            }
            CPreparedStatement pstm = DB.prepareStatement((String)sql, null);
            if (date != null) {
                pstm.setTimestamp(1, date);
            }
            ResultSet rs = pstm.executeQuery();
            this.m_table.loadTable(rs);
            if (this.m_table.getRowCount() > 0) {
                this.m_table.setRowSelectionInterval(0, 0);
            }
            this.enableButtons();
        }
        catch (Exception e) {
            log.severe("QueryTicket.setResults: " + e + " -> " + sql);
        }
    }

    @Override
    protected void enableButtons() {
        Integer ID;
        boolean enabled;
        this.m_c_order_id = -1;
        int row = this.m_table.getSelectedRow();
        boolean bl = enabled = row != -1;
        if (enabled && (ID = this.m_table.getSelectedRowKey()) != null) {
            this.m_c_order_id = ID;
        }
        this.f_ok.setEnabled(enabled);
        if (log.isLoggable(Level.INFO)) {
            log.info("ID=" + this.m_c_order_id);
        }
    }

    @Override
    protected void close() {
        if (log.isLoggable(Level.INFO)) {
            log.info("C_Order_ID=" + this.m_c_order_id);
        }
        if (this.m_c_order_id > 0) {
            this.p_posPanel.setOrder(this.m_c_order_id);
            this.p_posPanel.updateInfo();
        }
        this.dispose();
    }
}

