/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ecs;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import org.apache.ecs.Doctype;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.head;
import org.apache.ecs.xhtml.html;
import org.apache.ecs.xhtml.title;

public class XhtmlDocument
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 8143619141939879559L;
    private html html = new html();
    private head head = new head();
    private body body;
    private title title = new title();
    private String codeset = null;
    private Doctype doctype = null;

    public XhtmlDocument() {
        this.body = new body();
        this.head.addElement("title", this.title);
        this.html.addElement("head", this.head);
        this.html.addElement("body", this.body);
    }

    public XhtmlDocument(String codeset) {
        this.body = new body();
        this.head.addElement("title", this.title);
        this.html.addElement("head", this.head);
        this.html.addElement("body", this.body);
        this.setCodeset(codeset);
    }

    public Doctype getDoctype() {
        return this.doctype;
    }

    public XhtmlDocument setDoctype(Doctype set_doctype) {
        this.doctype = set_doctype;
        return this;
    }

    public html getHtml() {
        return this.html;
    }

    public XhtmlDocument setHtml(html set_html) {
        this.html = set_html;
        return this;
    }

    public head getHead() {
        return this.head;
    }

    public XhtmlDocument setHead(head set_head) {
        this.html.addElement("head", set_head);
        return this;
    }

    public XhtmlDocument appendHead(Element value) {
        this.head.addElement(value);
        return this;
    }

    public XhtmlDocument appendHead(String value) {
        this.head.addElement(value);
        return this;
    }

    public body getBody() {
        return this.body;
    }

    public XhtmlDocument setBody(body set_body) {
        this.html.addElement("body", set_body);
        return this;
    }

    public XhtmlDocument appendBody(Element value) {
        this.body.addElement(value);
        return this;
    }

    public XhtmlDocument appendBody(String value) {
        this.body.addElement(value);
        return this;
    }

    public title getTitle() {
        return this.title;
    }

    public XhtmlDocument setTitle(title set_title) {
        this.head.addElement("title", set_title);
        return this;
    }

    public XhtmlDocument appendTitle(Element value) {
        this.title.addElement(value);
        return this;
    }

    public XhtmlDocument appendTitle(String value) {
        this.title.addElement(value);
        return this;
    }

    public void setCodeset(String codeset) {
        this.codeset = codeset;
    }

    public String getCodeset() {
        return this.codeset;
    }

    public void output(OutputStream out) {
        if (this.doctype != null) {
            this.doctype.output(out);
            try {
                out.write(10);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.html.output(out);
    }

    public void output(PrintWriter out) {
        if (this.doctype != null) {
            this.doctype.output(out);
            try {
                out.write(10);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.html.output(out);
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getCodeset() != null) {
            if (this.doctype != null) {
                sb.append(this.doctype.toString(this.getCodeset()));
            }
            sb.append(this.html.toString(this.getCodeset()));
            return sb.toString();
        }
        if (this.doctype != null) {
            sb.append(this.doctype.toString());
        }
        sb.append(this.html.toString());
        return sb.toString();
    }

    public final String toString(String codeset) {
        StringBuilder sb = new StringBuilder();
        if (this.doctype != null) {
            sb.append(this.doctype.toString(this.getCodeset()));
        }
        sb.append(this.html.toString(this.getCodeset()));
        return sb.toString();
    }

    public Object clone() {
        return this.html.clone();
    }
}

