/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2;

import java.io.File;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.pipo2.PackIn;
import org.adempiere.pipo2.Zipper;
import org.compiere.Adempiere;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentEntry;
import org.compiere.model.X_AD_Package_Imp_Proc;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;

public class PackInProcess
extends SvrProcess {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private boolean m_UpdateDictionary = false;
    private String m_packageDirectory = null;
    public int p_PackIn_ID = 0;
    private String packageName = null;
    private String packageVersion = null;

    protected void prepare() {
        this.p_PackIn_ID = this.getRecord_ID();
        ProcessInfoParameter[] params = this.getParameter();
        if (params != null && params.length > 0) {
            ProcessInfoParameter[] processInfoParameterArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                ProcessInfoParameter param = processInfoParameterArray[n2];
                if ("Name".equals(param.getParameterName())) {
                    this.packageName = param.getParameter().toString();
                } else if ("Version".equals(param.getParameterName())) {
                    this.packageVersion = param.getParameter().toString();
                }
                ++n2;
            }
        }
    }

    protected String doIt() throws Exception {
        MAttachment attachment;
        boolean success;
        String targetDirName;
        File targetDir;
        X_AD_Package_Imp_Proc adPackageImp = new X_AD_Package_Imp_Proc(this.getCtx(), this.p_PackIn_ID, this.get_TrxName());
        String packageDirectory = adPackageImp.getAD_Package_Dir();
        if (packageDirectory == null || packageDirectory.trim().length() == 0) {
            packageDirectory = Adempiere.getAdempiereHome();
        }
        if (!(targetDir = new File(targetDirName = String.valueOf(packageDirectory) + File.separator + "packin")).exists() && !(success = targetDir.mkdirs())) {
            this.log.warning("Failed to create target directory. " + targetDirName);
        }
        if ((attachment = adPackageImp.getAttachment()) == null) {
            return "Please attach the pack out archive before running the process";
        }
        MAttachmentEntry entry = attachment.getEntry(0);
        if (entry == null) {
            return "Please attach the pack out archive before running the process";
        }
        File zipFilepath = entry.getFile();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("zipFilepath->" + zipFilepath);
        }
        String parentDir = Zipper.getParentDir(zipFilepath);
        Zipper.unpackFile(zipFilepath, targetDir);
        String dict_file = String.valueOf(packageDirectory) + File.separator + "packin" + File.separator + parentDir + File.separator + "dict" + File.separator + "PackOut.xml";
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("dict file->" + dict_file);
        }
        this.m_UpdateDictionary = adPackageImp.isAD_Override_Dict();
        this.m_packageDirectory = String.valueOf(packageDirectory) + File.separator + "packin" + File.separator + parentDir + File.separator;
        PackIn packIn = new PackIn();
        packIn.setPackageDirectory(this.m_packageDirectory);
        packIn.setPackageName(this.packageName);
        packIn.setPackageVersion(this.packageVersion);
        packIn.setUpdateDictionary(this.m_UpdateDictionary);
        String msg = packIn.importXML(dict_file, this.getCtx(), this.get_TrxName());
        adPackageImp.setDateProcessed(new Timestamp(System.currentTimeMillis()));
        adPackageImp.setP_Msg(msg);
        adPackageImp.saveEx();
        return msg;
    }
}

