package double_array;

import java.util.BitSet;
import java.util.List;
import java.util.ArrayList;

public class Allocator {
    public static final int PER_LINK_SIZE=0x100000;
    public static final int TRY_ALLOC_THRESHOLD=0x80;
    
    class Link {
	public Link(int p, int n) { prev=p; next=n; }
	public int next;
	public int prev;
    }

    private ArrayList<Link> lnk;
    private BitSet bset;
    private int begIndex;

    public Allocator() {
	lnk = new ArrayList<Link>();
	lnk.add(new Link(0,0));
	resizeLink(PER_LINK_SIZE);
	
	bset = new BitSet(PER_LINK_SIZE);
	bset.flip(1);

	begIndex = 0x10000; // TODO: CODE_LIMIT
    }
    
    private void resizeLink(int hint) {
	lnk.get(lnk.size()-1).next = lnk.size();
	int end = Math.max(hint, lnk.size()*2);
	
	for(int i=lnk.size(); i < end; i++)
	    lnk.add(new Link(i-1, i+1));
	lnk.get(lnk.size()-1).next = 0;
    }

    int xCheck(List<Character> codes) {
	int cur = lnk.get(begIndex).next;
	for(int cnt=0;; cur=lnk.get(cur).next, cnt++) {
	    int x = cur-codes.get(0);
	    if(bset.get(x)==false && canAllocate(codes, x)) {
		bset.flip(x);
		if(cnt > TRY_ALLOC_THRESHOLD)
		    begIndex = lnk.get(begIndex).next;

		for(int i=0; i < codes.size(); i++)
		    alloc(x+codes.get(i));
		return x;
	    }
	}
    }

    boolean canAllocate(List<Character> codes, int x) {
	for(int i=1; i < codes.size(); i++)
	    if(x+codes.get(i) < lnk.size() && lnk.get(x+codes.get(i)).next==0)
		return false;
	return true;
    }

    void alloc(int node) {
	while(node >= lnk.size()-1)
	    resizeLink(0);

	if(node==begIndex)
	    begIndex = lnk.get(begIndex).prev;

	allocImpl(node);
    }

    void allocImpl(int node) {
	lnk.get(lnk.get(node).prev).next = lnk.get(node).next;
	lnk.get(lnk.get(node).next).prev = lnk.get(node).prev;
	lnk.get(node).next = 0;
    }
}