package double_array;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class BinaryFileReader {
    BufferedInputStream fis;
    final long length;
    
    public BinaryFileReader(String filepath) throws IOException {
	File f = new File(filepath);
	length = f.length();
	fis = new BufferedInputStream(new FileInputStream(f));
    }

    public long length() { return length; }

    // XXX: eof check
    public byte readByte() throws IOException{
	return (byte)fis.read();
    }
    public char readChar() throws IOException {
	return (char)(fis.read() + (fis.read()<<8));
    }
    public int readInt() throws IOException {
	return fis.read() + (fis.read()<<8) + (fis.read()<<16) + (fis.read()<<24);
    }

    public void close() {
	try {
	    fis.close();
	} catch (IOException e) {}
    }
}
