package double_array;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class BinaryFileWriter {
    private BufferedOutputStream fos;

    public BinaryFileWriter(String filepath) throws IOException {
	fos=new BufferedOutputStream(new FileOutputStream(new File(filepath)));
    }

    public void close() {
	try {
	    fos.close();
	} catch (IOException e) {}
    }

    public void writeByte(byte n) throws IOException {
	fos.write(n);
    }

    public void writeChar(char n) throws IOException {
	fos.write(n&0xFF);
	fos.write((n>>8)&0xFF);
    }

    public void writeInt(int n) throws IOException {
	for(int i=0; i < 4; i++,n=n>>8)
	    fos.write(n&0xFF);
    }

    public void writeString(String s) throws IOException {
	for(int i=0; i < s.length(); i++) 
	    writeChar(s.charAt(i));
    }
}
