package double_array;

import java.io.File;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Collections;

public class Builder {
    private List<KeyStream> keyStreamList;

    private AutoArray<Base> base = new AutoArray<Base>();
    private AutoArray<Chck> chck = new AutoArray<Chck>();
    private ArrayList<Tind> tind = new ArrayList<Tind>();
    private StringBuilder   tail = new StringBuilder();

    public Builder(String keyFilePath, String encoding) {
	keyStreamList = readyKeyStreamList(keyFilePath, encoding);
	
	// sort
	Collections.<double_array.KeyStream>sort(keyStreamList);

	// unique
	// TODO: 改良
	KeyStream prev=null;
	List<KeyStream> ks = new ArrayList<KeyStream>();
	for(KeyStream k : keyStreamList) {
	    if(prev==null || k.compareTo(prev)!=0)
		ks.add(k);
	    prev=k;
	}

	keyStreamList = ks;
    }

    // TODO: 共通化
    public Builder(List<String> keyList) {
	// sort
	Collections.sort(keyList);

	// unique
	// TODO: 改良
	String prev=null;
	List<KeyStream> ks = new ArrayList<KeyStream>();
	for(String k : keyList) {
	    if(prev==null || k.compareTo(prev)!=0)
		ks.add(new KeyStream(k));
	    prev=k;
	}

	keyStreamList = ks;	
    }

    public void build() {
	Allocator alloca = new Allocator();
	buildImpl(keyStreamList, alloca, 0, keyStreamList.size(), 0);
    }

    public void save (String filepath) throws IOException {
	BinaryFileWriter bw = new BinaryFileWriter(filepath);
	try {
	    int nodeSize = chck.size();
	    
	    for(; nodeSize > 0 && chck.get(nodeSize-1).inUse()==false; nodeSize--);
	    nodeSize += Chck.CODE_LIMIT;

	    // write size
	    bw.writeInt(nodeSize);
	    bw.writeInt(tind.size());
	    bw.writeInt(tail.length());

	    // write data
	    for(Tind t : tind) {
		bw.writeInt(t.tail_offset);
		bw.writeInt(t.length);
	    }

	    for(int i=0; i < nodeSize; i++) 
		bw.writeInt(base.get(i,Base.class).base());

	    for(int i=0; i < nodeSize; i++)
		bw.writeChar(chck.get(i,Chck.class).data());
	    
	    final String ts = tail.toString();
	    for(int i=0; i < ts.length(); i++)
		bw.writeChar(ts.charAt(i));
	} finally {
	    bw.close();
	}
    }

    private void buildImpl(List<KeyStream> ksList, Allocator alloca, int beg, int end, int rootIdx) {
	//System.out.println(beg+" <=> "+end);
	if(end-beg==1) {
	    insertTail(ksList.get(beg), rootIdx);
	    return;  
	}

	List<Integer> endList = new ArrayList<Integer>();
	List<Character> codeList = new ArrayList<Character>();
	char prev=Chck.VACANT_CODE;
	
	for(int i=beg; i < end; i++) {
	    char cur = ksList.get(i).read();

	    if(prev != cur) {
		codeList.add(cur);
		prev = cur;
		endList.add(i);
	    }
	}
	endList.add(end);

	int x = alloca.xCheck(codeList);
	for(int i=0; i < codeList.size(); i++)
	    buildImpl(ksList, alloca, endList.get(i), endList.get(i+1), setNode(codeList.get(i),rootIdx,x));
    }

    private int setNode(char code, int prev, int xNode) {
	int next = xNode+code;
	base.get(prev,Base.class).setBase(xNode);
	chck.get(next,Chck.class).setChck(code);
	return next;
    }

    private void insertTail(KeyStream in, int node) {
	base.get(node,Base.class).setId(tind.size());
	/*
	if(in.eos()) {
	    tind.add(new Tind());
	    return;
	}
	*/
	tind.add(new Tind(tail.length(), in.rest().length()));
	tail.append(in.rest());
    }

    // for test
    public static void main(String[] args) throws Exception {
	Builder b = new Builder(args[0],"UTF-8");
	System.out.println("== build ==");
	b.build();
	System.out.println("== save ==");
	b.save(args[1]);
    }

    private List<KeyStream> readyKeyStreamList(String keyFilePath, String encoding) {
	List<KeyStream> ksList = new ArrayList<KeyStream>();

        FileInputStream fis = null;
        BufferedReader readFile = null;
	
        try {
	    fis         = new FileInputStream(keyFilePath);
            readFile    = new BufferedReader(new InputStreamReader(fis, encoding));
        } catch(Exception e) {
            e.printStackTrace();
        }
        
        String line;
        try {
            while((line = readFile.readLine()) != null) {
		ksList.add(new KeyStream(line));
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally{
            try {
                fis.close();
                readFile.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }	
	return ksList;
    }
}