package double_array;

class KeyStream implements Comparable {
    private final String key;
    private int cur;
    private int end;

    public KeyStream(String key) {
	this.key = key;
	this.cur = 0;
	this.end = key.length();
    }
    
    public KeyStream(String key, int start, int end) {
	this.key = key;
	this.cur = start;
	this.end = end;
    }
    
    public int compareTo(Object o) {
	// XXX:
	final KeyStream ks = (KeyStream)o;
	return key.substring(cur,end).compareTo(ks.key.substring(ks.cur,ks.end));
    }

    public String toString() {
	return key.substring(cur,end);
    }

    public String rest() {
	return key.substring(cur,end);
    }

    public char read() {
	return eos() ? Chck.TERMINATE_CODE : key.charAt(cur++);
    }
    public boolean eos() { return cur >= end; }
}