package double_array;

import java.util.ArrayList;
import java.io.IOException;

import java.io.File;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Collections;

public class Searcher {
    static private List<String> readLines(String filepath, String encoding) {
	List<String> lines = new ArrayList<String>();

        FileInputStream fis = null;
        BufferedReader readFile = null;
	
        try {
	    fis         = new FileInputStream(filepath);
            readFile    = new BufferedReader(new InputStreamReader(fis, encoding));
        } catch(Exception e) {
            e.printStackTrace();
        }
        
        String line;
        try {
            while((line = readFile.readLine()) != null) 
		lines.add(line);
        } catch (IOException e) {
            e.printStackTrace();
        } finally{
            try {
                fis.close();
                readFile.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }	
	return lines;
    }

    public int size() { return tind.length; }

    public static void main(String[] args) throws Exception {
	System.out.println("== load == ");
	Searcher s = new Searcher(args[0]);
	System.out.println(" => key size: "+s.tind.length);
	
	System.out.println("== keys load == ");	
	
	List<String> lines = readLines(args[1],"UTF-8");
	List<String> fails = new ArrayList<String>();

	System.out.println("== search == ");	
	for(int i=0; i < 1; i++) {
	    for(String k : lines) { 
		final Base b = s.search(k);
		if(b == Base.INVALID)
		    fails.add(k);
	    }
	}
	System.out.println(" => NOT FOUND: "+fails.size());
	for(int i=0; i < Math.min(10,fails.size()); i++)
	    System.out.println("  "+fails.get(i));
    }

    private final Base[] base;
    private final Chck[] chck;
    private final Tind[] tind;
    private final String          tail;

    public Searcher(String filepath) throws IOException {
	BinaryFileReader br = new BinaryFileReader(filepath);
	try {
	    final int nodeSize = br.readInt();
	    final int tindSize = br.readInt();
	    final int tailSize = br.readInt();

	    tind = readTind(br,tindSize);
	    base = readBase(br,nodeSize);
	    chck = readChck(br,nodeSize);
	    tail = readTail(br,tailSize);
	} finally {
	    br.close();
	}
    }
    
    // XXX: interface
    public Base search(String key) {
	Base node = base[0];
	KeyStream in = new KeyStream(key);

	for(char code=in.read();; code=in.read()) {
	    final int idx = node.nextIndex(code);
	    node = base[idx];
	    
	    if(chck[idx].transBy(code))
		if(node.isLeaf()==false)                continue;
		else if(in.eos() || keyExists(in,node)) return node;
	    return Base.INVALID;
	}
    }
    
    public interface Callback {
	public void call(int offset, int id);
    }

    public void eachCommonPrefix(String key, Callback fn) {
	Base node = base[0];
	int offset=0;
	KeyStream in = new KeyStream(key);
	
	for(char code=in.read();; code=in.read(),offset++) {
	    final int terminalIdx = node.nextIndex(Chck.TERMINATE_CODE);
	    if(chck[terminalIdx].transBy(Chck.TERMINATE_CODE)) {
		fn.call(offset,base[terminalIdx].id());
		if(code==Chck.TERMINATE_CODE)
		    return;
	    }
		
	    final int idx = node.nextIndex(code);
	    node = base[idx];
	    if(chck[idx].transBy(code))              
		if(node.isLeaf()==false)  continue;
		else if((offset=keyIncluding(in,node,offset))>0) fn.call(offset,node.id()); // XXX:
	    return;
	}
    }

    private int keyIncluding(KeyStream in, Base node, int offset) {
	final Tind  ti = tind[node.id()];
	final String s = tail.substring(ti.tail_offset, ti.tail_offset+ti.length);
	
	if(in.rest().startsWith(s))
	    return offset+ti.length+1;
	else
	    return -1;
    }
    
    private boolean keyExists(KeyStream in, Base node) {
	final Tind  ti = tind[node.id()];
	final String s = tail.substring(ti.tail_offset, ti.tail_offset+ti.length);
	return in.rest().equals(s);
    }

    private Tind[] readTind(BinaryFileReader br, int size) throws IOException {
	Tind[] ary = new Tind[size];
	for(int i=0; i < size; i++) 
	    ary[i] = new Tind(br.readInt(),br.readInt());
	return ary;
    }
    
    private Base[] readBase(BinaryFileReader br, int size) throws IOException {
	Base[] ary = new Base[size];
	for(int i=0; i < size; i++) 
	    ary[i] = new Base(br.readInt());
	return ary;
    }

    private Chck[] readChck(BinaryFileReader br, int size) throws IOException {
	Chck[] ary = new Chck[size];
	for(int i=0; i < size; i++) 
	    ary[i] = new Chck(br.readChar());
	return ary;
    }

    private String readTail(BinaryFileReader br, int size) throws IOException {
	StringBuilder sb = new StringBuilder();
	for(int i=0; i < size; i++)
	    sb.append(br.readChar());
	return sb.toString();
    }
}