package morpheme;

import java.util.ArrayList;
import java.util.List;
import java.io.IOException;

public class Igo {
    public static void main(String[] args) throws Exception {
	/*
	WordDic wDic = new WordDic(args[0], args[1], args[2]);
	wDic.genWordIdMap();
	wDic.genWordInfo();
	*/
	
	/*
	final WordDic wDic = new WordDic(args[1]);
	List<MorphemeNode> result = new ArrayList<MorphemeNode>();
	wDic.search(args[3], result);
	for(MorphemeNode mn : result) {
	    System.out.println("###");
	    System.out.println(mn.length);
	    System.out.println(wDic.getData(mn.word));
	}
	*/

	//Matrix.build(args[0],args[1]);
	//CharCategory.build(args[0],args[1],args[2]);
	/*
	final WordDic wDic = new WordDic(args[1]);
	final Unknown unk = new Unknown(args[1]);
	List<MorphemeNode> result = new ArrayList<MorphemeNode>();
	unk.search(args[3], wDic, result);
	for(MorphemeNode mn : result) {
	    System.out.println("###");
	    System.out.println(mn.length);
	    System.out.println(wDic.getData(mn.word));
	}	
	*/
	final Igo igo = new Igo(args[0]);
	ReadLine rl = new ReadLine(args[1],args[2]);
	String line;
	
	List<Morpheme> result = new ArrayList<Morpheme>();

	while((line=rl.read())!=null) {
	    result.clear();
	    
	    igo.parse(line,result);
	    for(Morpheme m : result)
		System.out.println(m.word+"\t"+m.attribute);
	    System.out.println("EOS");
	}
    }
    
    final WordDic wdc;
    final Unknown unk;
    final Matrix  mtx;
    
    public Igo(String dicDir) throws IOException {
	wdc = new WordDic(dicDir);
	unk = new Unknown(dicDir);
	mtx = new Matrix(dicDir);
    }

    public void parse(String text, List<Morpheme> result) {
	final int len = text.length();
	
	ArrayList<ArrayList<MorphemeNode>> nodesAry = new ArrayList<ArrayList<MorphemeNode>>(len+1);
	for(int i=0; i <= len; i++) 
	    nodesAry.add(new ArrayList<MorphemeNode>());
	
	nodesAry.get(0).add(new MorphemeNode(Word.BOS_EOS_WORD,0));
	for(int i=0; i < len; i++) {
	    if(nodesAry.get(i).isEmpty()==false) {
		final List<MorphemeNode> prevs = nodesAry.get(i);
		List<MorphemeNode> rlt = new ArrayList<MorphemeNode>();
		
		final String curText = text.substring(i);
		wdc.search(curText, rlt);
		unk.search(curText, wdc, rlt);

		for(MorphemeNode mn : rlt) {
		    nodesAry.get(i+mn.length).add(mn);
		    setMincostNode(mn, prevs);
		}
	    }
	}
	
	// EOS
	MorphemeNode eos = new MorphemeNode(Word.BOS_EOS_WORD, 0);
	setMincostNode(eos,nodesAry.get(len));
	
	MorphemeNode cur = eos.prev;
	List<MorphemeNode> tmp = new ArrayList<MorphemeNode>();
	while(cur.prev != null) {
	    tmp.add(cur);
	    cur = cur.prev;
	}

	int start=0;
	for(int i=tmp.size()-1; i >=0; i--) {
	    final MorphemeNode mn = tmp.get(i);
	    final String name = text.substring(start, start+mn.length);
	    start += mn.length;
	    
	    final String data = wdc.getData(mn.word);
	    
	    result.add(new Morpheme(name, data));
	}
    }

    private void setMincostNode(MorphemeNode mn, List<MorphemeNode> prevs) {
	for(MorphemeNode p : prevs) {
	    final int cost = p.cost + mtx.linkCost(p.word.rightId, mn.word.leftId);
	    if(cost < mn.cost) {
		mn.cost = cost;
		mn.prev = p;
	    }
	}
	mn.cost += mn.word.cost;
    }
}