package morpheme;

import double_array.BinaryFileWriter;
import double_array.BinaryFileReader;
import java.io.IOException;

public class Matrix {
    public static void build(String inputDir, String outputDir) throws IOException {
	ReadLine rl = new ReadLine(inputDir+"/matrix.def","UTF-8");
	BinaryFileWriter bw = new BinaryFileWriter(outputDir+"/matrix.bin");
	try {
	    // 一行目はサイズ
	    String s = rl.read();
	    int pos = s.indexOf(' ');
	    final int leftNum = Integer.valueOf(s.substring(0,pos));
	    final int rightNum= Integer.valueOf(s.substring(pos+1));
	    bw.writeInt(leftNum);
	    bw.writeInt(rightNum);
	    
	    // 二行目以降はデータ
	    // TODO: validation
	    for(int i=0; i < leftNum; i++)
		for(int j=0; j < rightNum; j++) {
		    s = rl.read();
		    final int cost = Integer.valueOf(s.substring(s.lastIndexOf(' ')+1));
		    bw.writeInt(cost);
		}
	} finally {
	    bw.close();
	    rl.close();
	}
    }

    private final int leftSize;
    private final int rightSize;
    private final int[] matrix;

    public Matrix(String outputDir) throws IOException {
	BinaryFileReader br = new BinaryFileReader(outputDir+"/matrix.bin");
	try {
	    leftSize = br.readInt();
	    rightSize= br.readInt();
	    matrix = new int[leftSize*rightSize];
	    for(int i=0; i < leftSize; i++)
		for(int j=0; j < rightSize; j++)
		    matrix[i*leftSize + j] = br.readInt();
	} finally {
	    br.close();
	}
    }

    public int linkCost(int leftId, int rightId) {
	return matrix[leftId*leftSize + rightId];
    }
}