package morpheme;

import java.io.IOException;
import java.util.List;

public class Unknown {
    final CharCategory category;
    
    public Unknown(String outputDir) throws IOException {
	category = new CharCategory(outputDir);
    }

    public void search(String text, WordDic wdic, List<MorphemeNode> result) {
	final char c = text.charAt(0); // XXX: check out of range
	final CharCategory.Entry e = category.category(c);
	
	// 既に辞書単語との一致があり、invokeフラグもfalseなら、ここで終了
	if(result.isEmpty()==false && e.invoke==false)
	    return;

	//
	boolean b=true;
	final int limit = Math.min(text.length(), e.length);
	int i=0;
	for(; i < limit; i++) { 
	    wdic.searchFromId(e.id, i+1, result);
	    if(i+1!=limit &&
	       category.isCompatible(c, text.charAt(i+1)) == false) {
		b=false;
		break;
	    }
	}

	// group
	if(e.group && b && i < text.length()) {
	    for(i++; i < text.length(); i++)
		if(category.isCompatible(c, text.charAt(i)) == false) {
		    wdic.searchFromId(e.id, i, result);
		    return;
		}
	    wdic.searchFromId(e.id, text.length(), result);
	}
    }
}