/*
 * Decompiled with CFR 0.152.
 */
package net.reduls.igo.dictionary;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.reduls.igo.dictionary.ViterbiNode;
import net.reduls.igo.dictionary.Word;
import net.reduls.igo.trie.Builder;
import net.reduls.igo.trie.Searcher;
import net.reduls.igo.util.FileMappedInputStream;
import net.reduls.igo.util.FileMappedOutputStream;
import net.reduls.igo.util.ReadLine;

public final class WordDic {
    private final Searcher trie;
    private final String data;
    private final Word word;
    private final int[] indices;

    public WordDic(String string) throws IOException {
        this.trie = new Searcher(string + "/word2id");
        this.word = new Word(string + "/word.inf");
        this.data = FileMappedInputStream.getString(string + "/word.dat");
        this.indices = FileMappedInputStream.getIntArray(string + "/word.ary.idx");
    }

    public short cost(int n) {
        return this.word.costs[n];
    }

    public short leftId(int n) {
        return this.word.leftIds[n];
    }

    public short rightId(int n) {
        return this.word.rightIds[n];
    }

    public int dataOffset(int n) {
        return this.word.dataOffsets[n];
    }

    public void search(String string, List<ViterbiNode> list) {
        this.trie.eachCommonPrefix(string, new Collect(list));
    }

    public void searchFromId(int n, int n2, List<ViterbiNode> list) {
        int n3 = this.indices[n + 1];
        for (int i = this.indices[n]; i < n3; ++i) {
            list.add(new ViterbiNode(i, (short)n2, this.leftId(i), this.rightId(i)));
        }
    }

    public String wordData(int n) {
        return this.data.substring(this.dataOffset(n), this.dataOffset(n + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void collectKey(ReadLine readLine, List<String> list, String string) throws IOException {
        try {
            String string2 = readLine.read();
            while (string2 != null) {
                String string3 = string2.substring(0, string2.indexOf(44));
                list.add(string + string3);
                string2 = readLine.read();
            }
        }
        finally {
            readLine.close();
        }
    }

    public static void genWordIdMap(String string, String string2, String string3) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        WordDic.collectKey(new ReadLine(string + "/unk.def", string3), arrayList, "\u0002");
        for (File file : new File(string).listFiles(new onlyCsv())) {
            WordDic.collectKey(new ReadLine(file.getPath(), string3), arrayList, "");
        }
        Builder builder = Builder.build(arrayList);
        builder.save(string2 + "/word2id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void collectWordInfo(ReadLine readLine, Searcher searcher, String string, ArrayList<ArrayList<WordInfo>> arrayList) throws IOException {
        try {
            String string2 = readLine.read();
            while (string2 != null) {
                int n = string2.indexOf(44);
                int n2 = string2.indexOf(44, n + 1);
                int n3 = string2.indexOf(44, n2 + 1);
                int n4 = string2.indexOf(44, n3 + 1);
                String string3 = string2.substring(n4 + 1);
                int n5 = searcher.search(string + string2.substring(0, n));
                if (n5 < 0) {
                    throw new IOException("Word '" + string2.substring(0, n) + "' is unregistered in trie");
                }
                arrayList.get(n5).add(new WordInfo(Short.valueOf(string2.substring(n + 1, n2)), Short.valueOf(string2.substring(n2 + 1, n3)), Short.valueOf(string2.substring(n3 + 1, n4)), string3));
                string2 = readLine.read();
            }
        }
        finally {
            readLine.close();
        }
    }

    private static void removeUnusedEntry(ArrayList<ArrayList<WordInfo>> arrayList) {
        for (ArrayList<WordInfo> arrayList2 : arrayList) {
            int n;
            Collections.sort(arrayList2);
            int n2 = 0;
            for (n = 1; n < arrayList2.size(); ++n) {
                if (arrayList2.get((int)n2).leftId == arrayList2.get((int)n).leftId && arrayList2.get((int)n2).rightId == arrayList2.get((int)n).rightId) continue;
                arrayList2.set(++n2, arrayList2.get(n));
            }
            for (n = arrayList2.size() - 1; n > n2; --n) {
                arrayList2.remove(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void genWordInfo(String string, String string2, String string3) throws IOException {
        Searcher searcher = new Searcher(string2 + "/word2id");
        ArrayList<ArrayList<WordInfo>> arrayList = new ArrayList<ArrayList<WordInfo>>(searcher.size());
        for (int i = 0; i < searcher.size(); ++i) {
            arrayList.add(new ArrayList());
        }
        WordDic.collectWordInfo(new ReadLine(string + "/unk.def", string3), searcher, "\u0002", arrayList);
        for (File object22 : new File(string).listFiles(new onlyCsv())) {
            WordDic.collectWordInfo(new ReadLine(object22.getPath(), string3), searcher, "", arrayList);
        }
        WordDic.removeUnusedEntry(arrayList);
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (ArrayList<WordInfo> arrayList2 : arrayList) {
            n += arrayList2.size();
        }
        FileMappedOutputStream fileMappedOutputStream = new FileMappedOutputStream(string2 + "/word.inf", (n + 1) * 10);
        try {
            for (ArrayList<WordInfo> arrayList3 : arrayList) {
                for (Object object : arrayList3) {
                    fileMappedOutputStream.putShort(((WordInfo)object).leftId);
                }
            }
            fileMappedOutputStream.putShort((short)0);
            for (ArrayList<WordInfo> arrayList4 : arrayList) {
                for (Object object : arrayList4) {
                    fileMappedOutputStream.putShort(((WordInfo)object).rightId);
                }
            }
            fileMappedOutputStream.putShort((short)0);
            for (ArrayList<WordInfo> arrayList5 : arrayList) {
                for (Object object : arrayList5) {
                    fileMappedOutputStream.putShort(((WordInfo)object).cost);
                }
            }
            fileMappedOutputStream.putShort((short)0);
            for (ArrayList<WordInfo> arrayList6 : arrayList) {
                for (Object object : arrayList6) {
                    fileMappedOutputStream.putInt(stringBuilder.length());
                    stringBuilder.append(((WordInfo)object).data);
                }
            }
            fileMappedOutputStream.putInt(stringBuilder.length());
        }
        finally {
            fileMappedOutputStream.close();
        }
        FileMappedOutputStream fileMappedOutputStream2 = new FileMappedOutputStream(string2 + "/word.dat", stringBuilder.length() * 2);
        try {
            fileMappedOutputStream2.putString(stringBuilder.toString());
        }
        finally {
            fileMappedOutputStream2.close();
        }
        FileMappedOutputStream fileMappedOutputStream3 = new FileMappedOutputStream(string2 + "/word.ary.idx", (arrayList.size() + 1) * 4);
        int n2 = 0;
        try {
            for (ArrayList arrayList7 : arrayList) {
                fileMappedOutputStream3.putInt(n2);
                n2 += arrayList7.size();
            }
            fileMappedOutputStream3.putInt(n2);
        }
        finally {
            fileMappedOutputStream3.close();
        }
    }

    private static class onlyCsv
    implements FileFilter {
        private onlyCsv() {
        }

        @Override
        public boolean accept(File file) {
            return file.isFile() && file.toString().matches(".*\\.csv$");
        }
    }

    private static class WordInfo
    implements Comparable<WordInfo> {
        public short leftId;
        public short rightId;
        public short cost;
        public String data;

        public WordInfo(short s, short s2, short s3, String string) {
            this.leftId = s;
            this.rightId = s2;
            this.cost = s3;
            this.data = string;
        }

        @Override
        public int compareTo(WordInfo wordInfo) {
            if (this.leftId != wordInfo.leftId) {
                return this.leftId - wordInfo.leftId;
            }
            if (this.rightId != wordInfo.rightId) {
                return this.rightId - wordInfo.rightId;
            }
            return this.cost - wordInfo.cost;
        }
    }

    private class Collect
    implements Searcher.Callback {
        public final List<ViterbiNode> ms;

        public Collect(List<ViterbiNode> list) {
            this.ms = list;
        }

        @Override
        public void call(int n, int n2) {
            int n3 = WordDic.this.indices[n2 + 1];
            for (int i = WordDic.this.indices[n2]; i < n3; ++i) {
                this.ms.add(new ViterbiNode(i, (short)n, WordDic.this.leftId(i), WordDic.this.rightId(i)));
            }
        }
    }
}

