package net.reduls.igo.dictionary;

import java.io.IOException;
import java.io.EOFException;
import java.text.ParseException;
import net.reduls.igo.util.ReadLine;
import net.reduls.igo.util.FileMappedInputStream;
import net.reduls.igo.util.FileMappedOutputStream;

public final class Matrix {
    public static void build(String inputDir, String outputDir) throws IOException, ParseException {
	final ReadLine rl = new ReadLine(inputDir+"/matrix.def", "UTF-8"); 
	try {
	    // 一行目はサイズ: [左文脈IDの数] [右文脈IDの数]
	    String s = rl.readEof();
	    final int leftNum = Integer.valueOf(s.substring(0,s.indexOf(' ')));
	    final int rightNum= Integer.valueOf(s.substring(s.indexOf(' ')+1));
	    final FileMappedOutputStream fmos =
		new FileMappedOutputStream(outputDir+"/matrix.bin", 4*2+leftNum*rightNum*2);
	    try {
		fmos.putInt(leftNum);
		fmos.putInt(rightNum);
	    
		// 二行目以降はデータ: [左文脈ID] [右文脈ID] [連接コスト]
		for(int i=0; i < leftNum; i++)
		    for(int j=0; j < rightNum; j++) {
			s = rl.readEof();
			final int p1 = s.indexOf(' ');
			final int p2 = s.indexOf(' ',p1+1);
			
			final int   lftID = Integer.valueOf(s.substring(0,    p1));
			final int   rgtID = Integer.valueOf(s.substring(p1+1, p2));
			final short cost  =   Short.valueOf(s.substring(p2+1));
			
			if(i != lftID) throw new ParseException
					   ("Unexpected left context ID. ID="+lftID+", expedted="+i, rl.lineNumber());
			if(j != rgtID) throw new ParseException
					   ("Unexpected right context ID. ID="+rgtID+", expedted="+j, rl.lineNumber());
			fmos.putShort(cost);
		    }
	    } finally {
		fmos.close();
	    }
	} catch (NumberFormatException e) {
	    throw new ParseException("Parse number failed. "+e.getMessage(), rl.lineNumber());
	} catch (EOFException e) {
	    throw new ParseException("End of file reached", rl.lineNumber());
	} finally {
	    rl.close();
	}
    }

    private final int     leftSize;
    private final int     rightSize;
    private final short[] matrix;

    public Matrix(String dataDir) throws IOException {
	final FileMappedInputStream fmis = new FileMappedInputStream(dataDir+"/matrix.bin");
	try {
	    leftSize = fmis.getInt();
	    rightSize= fmis.getInt();
	    matrix   = fmis.getShortArray(leftSize*rightSize);
	} finally {
	    fmis.close();
	}
    }

    public short linkCost(int leftId, int rightId) {
	return matrix[leftId*leftSize+rightId];
    }
}