package net.reduls.igo.dictionary;

import java.io.IOException;
import net.reduls.igo.util.FileMappedInputStream;

final class Word {
    public final int     count;
    public final short[] costs;
    public final short[] leftIds;
    public final short[] rightIds;
    public final int[]   dataOffsets;

    public Word(String filepath) throws IOException {
	final FileMappedInputStream fmis = new FileMappedInputStream(filepath);
	count = fmis.size()/(2+2+2+4);
	
	try {
	    leftIds    = fmis.getShortArray(count);
	    rightIds   = fmis.getShortArray(count);
	    costs      = fmis.getShortArray(count);
	    dataOffsets= fmis.getIntArray(count);
	} finally {
	    fmis.close();
	}
    }
}