package net.reduls.igo.trie;

final class KeyStream implements Comparable<KeyStream> {
    private final String s;
    private int cur;

    public KeyStream(String key) {
	s   = key;
	cur = 0;
    }

    public int compareTo(KeyStream ks) {
	return s.substring(cur).compareTo(ks.s.substring(ks.cur));
    }
    
    public boolean startsWith(String prefix, int beg, int len) {
	if(s.length()-cur < len)
	    return false;
	
	for(int i=0; i < len; i++)
	    if(s.charAt(cur+i) != prefix.charAt(beg+i))
		return false;
	return true;
    }

    public String rest() { return s.substring(cur); }
    public char   read() { return eos() ? Node.Chck.TERMINATE_CODE : s.charAt(cur++); }
    public boolean eos() { return cur == s.length(); }
}