/*
 * Decompiled with CFR 0.152.
 */
package net.reduls.igo.trie;

import java.io.IOException;
import net.reduls.igo.trie.KeyStream;
import net.reduls.igo.trie.Node;
import net.reduls.igo.util.FileMappedInputStream;

public final class Searcher {
    private final int keySetSize;
    private final int[] base;
    private final char[] chck;
    private final int[] begs;
    private final short[] lens;
    private final String tail;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Searcher(String string) throws IOException {
        FileMappedInputStream fileMappedInputStream = new FileMappedInputStream(string);
        try {
            int n = fileMappedInputStream.getInt();
            int n2 = fileMappedInputStream.getInt();
            int n3 = fileMappedInputStream.getInt();
            this.keySetSize = n2;
            this.begs = fileMappedInputStream.getIntArray(n2);
            this.lens = fileMappedInputStream.getShortArray(n2);
            this.base = fileMappedInputStream.getIntArray(n);
            this.chck = fileMappedInputStream.getCharArray(n);
            this.tail = fileMappedInputStream.getString(n3);
        }
        finally {
            fileMappedInputStream.close();
        }
    }

    public int size() {
        return this.keySetSize;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int search(String string) {
        int n = this.base[0];
        KeyStream keyStream = new KeyStream(string);
        char c = keyStream.read();
        while (true) {
            int n2 = n + c;
            n = this.base[n2];
            if (this.chck[n2] != c) return -1;
            if (n < 0) {
                if (!keyStream.eos() && !this.keyExists(keyStream, n)) return -1;
                return Node.Base.ID(n);
            }
            c = keyStream.read();
        }
    }

    public void eachCommonPrefix(String string, Callback callback) {
        int n = this.base[0];
        int n2 = 0;
        KeyStream keyStream = new KeyStream(string);
        char c = keyStream.read();
        while (true) {
            block7: {
                block6: {
                    int n3;
                    if (this.chck[n3 = n + 0] == '\u0000') {
                        callback.call(n2, Node.Base.ID(this.base[n3]));
                        if (c == '\u0000') {
                            return;
                        }
                    }
                    int n4 = n + c;
                    n = this.base[n4];
                    if (this.chck[n4] != c) break block6;
                    if (n >= 0) break block7;
                    this.call_if_keyIncluding(keyStream, n, n2, callback);
                }
                return;
            }
            c = keyStream.read();
            ++n2;
        }
    }

    private void call_if_keyIncluding(KeyStream keyStream, int n, int n2, Callback callback) {
        int n3 = Node.Base.ID(n);
        if (keyStream.startsWith(this.tail, this.begs[n3], this.lens[n3])) {
            callback.call(n2 + this.lens[n3] + 1, n3);
        }
    }

    private boolean keyExists(KeyStream keyStream, int n) {
        int n2 = Node.Base.ID(n);
        String string = this.tail.substring(this.begs[n2], this.begs[n2] + this.lens[n2]);
        return keyStream.rest().equals(string);
    }

    public static interface Callback {
        public void call(int var1, int var2);
    }
}

