package net.reduls.igo.bin;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import net.reduls.igo.dictionary.Matrix;
import net.reduls.igo.dictionary.WordDic;
import net.reduls.igo.dictionary.CharCategory;

public final class BuildDic {
    public static void main(String[] args) throws IOException, ParseException {
	if(args.length != 3) {
	    System.err.println("Usage: java net.reduls.igo.bin.BuildDic <output directory> <input directory> <encoding>");
	    System.exit(1);
	}
	final String outputDir = args[0];
	final String inputDir  = args[1];
	final String encoding  = args[2];

	new File(outputDir).mkdirs();

	System.err.println("### Build word trie");
	WordDic.genWordIdMap(inputDir, outputDir, encoding);
	
	System.err.println("### Build word dictionary");
	WordDic.genWordInfo(inputDir, outputDir, encoding);
	
	System.err.println("### Build matrix");
	Matrix.build(inputDir, outputDir);

	System.err.println("### Build char-category dictionary");
	CharCategory.build(inputDir, outputDir, encoding);
	
	System.err.println("DONE");
    }   
}