package net.reduls.igo.dictionary;

import java.io.IOException;
import java.util.List;

public final class Unknown {
    private final CharCategory category;
    private final int spaceId;

    public Unknown(String dataDir) throws IOException {
	category = new CharCategory(dataDir);
	spaceId = category.category(' ').id;
    }
    
    public void search(String text, int start, WordDic wdic, List<ViterbiNode> result) {
	final char ch = text.charAt(start);
	final CharCategory.Category ct = category.category(ch);

	if(result.isEmpty()==false && ct.invoke==false)
	    return;
	
	final boolean isSpace = ct.id==spaceId;
	boolean b=true;
	final int limit = Math.min(text.length(), ct.length+start);
	int i=start;
	for(; i < limit; i++) { 
	    wdic.searchFromId(ct.id, start, (i-start)+1, isSpace, result);
	    if(i+1!=limit &&
	       category.isCompatible(ch, text.charAt(i+1)) == false) {
		b=false;
		break;
	    }
	}
	
	if(ct.group && b && i < text.length()) {
	    for(; i < text.length(); i++)
		if(category.isCompatible(ch, text.charAt(i)) == false) {
		    wdic.searchFromId(ct.id, start, i-start, isSpace, result);
		    return;
		}
	    wdic.searchFromId(ct.id, start, text.length()-start, isSpace, result);
	}
    }
}