package net.reduls.igo.dictionary;

public final class ViterbiNode {
    public int         cost = 0;
    public ViterbiNode prev = null;

    public final int   wordId;
    public final short leftId;
    public final short rightId;
    public final int   start;
    public final short length;

    public final boolean isSpace;
    
    public ViterbiNode(int wid, int beg, short len, short l, short r, boolean space) {
	wordId = wid;
	leftId = l;
	rightId =r;
	length = len;
	isSpace = space;
	start = beg;
    }

    public static ViterbiNode makeBOSEOS() { 
	return new ViterbiNode(0,0,(short)0,(short)0,(short)0,false); 
    }
}