/*
 * Decompiled with CFR 0.152.
 */
package net.reduls.igo.analysis.ipadic;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import net.reduls.igo.Morpheme;
import net.reduls.igo.Tagger;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;

public final class IpadicTokenizer
extends Tokenizer {
    private final Tagger tagger;
    private Iterator<Morpheme> curToken = new ArrayList().iterator();
    private int offset = 0;
    private BufferedReader br;
    private TermAttribute termAtt;
    private OffsetAttribute offsetAtt;
    private TypeAttribute typeAtt;

    public IpadicTokenizer(Tagger tagger, Reader reader) {
        super(reader);
        this.tagger = tagger;
        this.br = new BufferedReader(reader);
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
        this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        this.typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    }

    public boolean incrementToken() throws IOException {
        this.clearAttributes();
        Morpheme morpheme = this.readMorpheme();
        if (morpheme == null) {
            return false;
        }
        this.offset = morpheme.start + morpheme.surface.length();
        this.offsetAtt.setOffset(this.correctOffset(morpheme.start), this.correctOffset(this.offset));
        int n = morpheme.feature.indexOf(",");
        int n2 = morpheme.feature.indexOf(",", n + 1);
        int n3 = morpheme.feature.indexOf(",", n2 + 1);
        int n4 = morpheme.feature.indexOf(",", n3 + 1);
        int n5 = morpheme.feature.indexOf(",", n4 + 1);
        int n6 = morpheme.feature.indexOf(",", n5 + 1);
        int n7 = morpheme.feature.indexOf(",", n6 + 1);
        if (n6 != -1) {
            this.typeAtt.setType(morpheme.feature.substring(0, n6));
        } else {
            this.typeAtt.setType(morpheme.feature);
        }
        if (n7 != -1) {
            this.termAtt.setTermBuffer(morpheme.feature.substring(n6 + 1, n7));
        } else {
            this.termAtt.setTermBuffer(morpheme.surface);
        }
        return true;
    }

    public final void end() {
        int n = this.correctOffset(this.offset);
        this.offsetAtt.setOffset(n, n);
    }

    public void reset() throws IOException {
        super.reset();
        this.offset = 0;
        this.curToken = new ArrayList().iterator();
    }

    public void reset(Reader reader) throws IOException {
        super.reset(reader);
        this.reset();
        this.br = new BufferedReader(reader);
    }

    private Morpheme readMorpheme() throws IOException {
        if (!this.curToken.hasNext()) {
            String string = this.br.readLine();
            if (string == null) {
                return null;
            }
            this.curToken = this.tagger.parse(string).iterator();
            return this.readMorpheme();
        }
        return this.curToken.next();
    }
}

