/*
 * Decompiled with CFR 0.152.
 */
package net.reduls.igo;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.reduls.igo.Morpheme;
import net.reduls.igo.dictionary.Matrix;
import net.reduls.igo.dictionary.Unknown;
import net.reduls.igo.dictionary.ViterbiNode;
import net.reduls.igo.dictionary.WordDic;

public final class Tagger {
    private static final ArrayList<ViterbiNode> BOS_NODES = new ArrayList(1);
    private final WordDic wdc;
    private final Unknown unk;
    private final Matrix mtx;

    public Tagger(String string) throws FileNotFoundException, IOException {
        this.wdc = new WordDic(string);
        this.unk = new Unknown(string);
        this.mtx = new Matrix(string);
    }

    public List<Morpheme> parse(CharSequence charSequence) {
        return this.parse(charSequence, new ArrayList<Morpheme>(charSequence.length() / 2));
    }

    public List<Morpheme> parse(CharSequence charSequence, List<Morpheme> list) {
        ViterbiNode viterbiNode = this.parseImpl(charSequence);
        while (viterbiNode != null) {
            String string = ((Object)charSequence.subSequence(viterbiNode.start, viterbiNode.start + viterbiNode.length)).toString();
            String string2 = this.wdc.wordData(viterbiNode.wordId);
            list.add(new Morpheme(string, string2, viterbiNode.start));
            viterbiNode = viterbiNode.prev;
        }
        return list;
    }

    public List<String> wakati(CharSequence charSequence) {
        return this.wakati(charSequence, new ArrayList<String>(charSequence.length() / 2));
    }

    public List<String> wakati(CharSequence charSequence, List<String> list) {
        ViterbiNode viterbiNode = this.parseImpl(charSequence);
        while (viterbiNode != null) {
            list.add(((Object)charSequence.subSequence(viterbiNode.start, viterbiNode.start + viterbiNode.length)).toString());
            viterbiNode = viterbiNode.prev;
        }
        return list;
    }

    private ViterbiNode parseImpl(CharSequence charSequence) {
        Object object;
        int n;
        int n2 = charSequence.length();
        ArrayList arrayList = new ArrayList(n2 + 1);
        ArrayList<ViterbiNode> arrayList2 = new ArrayList<ViterbiNode>();
        arrayList.add(BOS_NODES);
        for (n = 1; n <= n2; ++n) {
            arrayList.add(new ArrayList());
        }
        for (n = 0; n < n2; ++n) {
            if (!((ArrayList)arrayList.get(n)).isEmpty()) {
                this.wdc.search(charSequence, n, arrayList2);
                this.unk.search(charSequence, n, this.wdc, arrayList2);
                object = (ArrayList)arrayList.get(n);
                for (int i = 0; i < arrayList2.size(); ++i) {
                    ViterbiNode viterbiNode = arrayList2.get(i);
                    if (viterbiNode.isSpace) {
                        ((ArrayList)arrayList.get(n + viterbiNode.length)).addAll(object);
                        continue;
                    }
                    ((ArrayList)arrayList.get(n + viterbiNode.length)).add(this.setMincostNode(viterbiNode, (ArrayList<ViterbiNode>)object));
                }
            }
            arrayList2.clear();
        }
        ViterbiNode viterbiNode = this.setMincostNode((ViterbiNode)ViterbiNode.makeBOSEOS(), (ArrayList<ViterbiNode>)((ArrayList)arrayList.get((int)n2))).prev;
        object = null;
        while (viterbiNode.prev != null) {
            ViterbiNode viterbiNode2 = viterbiNode.prev;
            viterbiNode.prev = object;
            object = viterbiNode;
            viterbiNode = viterbiNode2;
        }
        return object;
    }

    private ViterbiNode setMincostNode(ViterbiNode viterbiNode, ArrayList<ViterbiNode> arrayList) {
        ViterbiNode viterbiNode2 = viterbiNode.prev = arrayList.get(0);
        viterbiNode.cost = viterbiNode2.cost + this.mtx.linkCost(viterbiNode2.rightId, viterbiNode.leftId);
        for (int i = 1; i < arrayList.size(); ++i) {
            ViterbiNode viterbiNode3 = arrayList.get(i);
            int n = viterbiNode3.cost + this.mtx.linkCost(viterbiNode3.rightId, viterbiNode.leftId);
            if (n >= viterbiNode.cost) continue;
            viterbiNode.cost = n;
            viterbiNode.prev = viterbiNode3;
        }
        viterbiNode.cost += this.wdc.cost(viterbiNode.wordId);
        return viterbiNode;
    }

    static {
        BOS_NODES.add(ViterbiNode.makeBOSEOS());
    }
}

