/*
 * Decompiled with CFR 0.152.
 */
package net.reduls.igo;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.reduls.igo.Morpheme;
import net.reduls.igo.dictionary.Matrix;
import net.reduls.igo.dictionary.Unknown;
import net.reduls.igo.dictionary.ViterbiNode;
import net.reduls.igo.dictionary.WordDic;

public final class Tagger {
    private static final ViterbiNodeList BOS_NODES = new ViterbiNodeList();
    private final WordDic wdc;
    private final Unknown unk;
    private final Matrix mtx;

    public Tagger(String string) throws FileNotFoundException, IOException {
        this.wdc = new WordDic(string);
        this.unk = new Unknown(string);
        this.mtx = new Matrix(string);
    }

    public List<Morpheme> parse(CharSequence charSequence) {
        return this.parse(charSequence, new ArrayList<Morpheme>(charSequence.length() / 2));
    }

    public List<Morpheme> parse(CharSequence charSequence, List<Morpheme> list) {
        ViterbiNode viterbiNode = this.parseImpl(charSequence);
        while (viterbiNode != null) {
            String string = ((Object)charSequence.subSequence(viterbiNode.start, viterbiNode.start + viterbiNode.length)).toString();
            String string2 = this.wdc.wordData(viterbiNode.wordId);
            list.add(new Morpheme(string, string2, viterbiNode.start));
            viterbiNode = viterbiNode.prev;
        }
        return list;
    }

    public List<String> wakati(CharSequence charSequence) {
        return this.wakati(charSequence, new ArrayList<String>(charSequence.length() / 2));
    }

    public List<String> wakati(CharSequence charSequence, List<String> list) {
        ViterbiNode viterbiNode = this.parseImpl(charSequence);
        while (viterbiNode != null) {
            list.add(((Object)charSequence.subSequence(viterbiNode.start, viterbiNode.start + viterbiNode.length)).toString());
            viterbiNode = viterbiNode.prev;
        }
        return list;
    }

    private ViterbiNode parseImpl(CharSequence charSequence) {
        int n = charSequence.length();
        ViterbiNodeList[] viterbiNodeListArray = new ViterbiNodeList[n + 1];
        viterbiNodeListArray[0] = BOS_NODES;
        MakeLattice makeLattice = new MakeLattice(viterbiNodeListArray);
        for (int i = 0; i < n; ++i) {
            if (viterbiNodeListArray[i] == null) continue;
            makeLattice.set(i);
            this.wdc.search(charSequence, i, makeLattice);
            this.unk.search(charSequence, i, this.wdc, makeLattice);
        }
        ViterbiNode viterbiNode = this.setMincostNode((ViterbiNode)ViterbiNode.makeBOSEOS(), (ViterbiNodeList)viterbiNodeListArray[n]).prev;
        ViterbiNode viterbiNode2 = null;
        while (viterbiNode.prev != null) {
            ViterbiNode viterbiNode3 = viterbiNode.prev;
            viterbiNode.prev = viterbiNode2;
            viterbiNode2 = viterbiNode;
            viterbiNode = viterbiNode3;
        }
        return viterbiNode2;
    }

    private ViterbiNode setMincostNode(ViterbiNode viterbiNode, ViterbiNodeList viterbiNodeList) {
        ViterbiNode viterbiNode2 = viterbiNode.prev = (ViterbiNode)viterbiNodeList.get(0);
        int n = viterbiNode2.cost + this.mtx.linkCost(viterbiNode2.rightId, viterbiNode.leftId);
        for (int i = 1; i < viterbiNodeList.size(); ++i) {
            ViterbiNode viterbiNode3 = (ViterbiNode)viterbiNodeList.get(i);
            int n2 = viterbiNode3.cost + this.mtx.linkCost(viterbiNode3.rightId, viterbiNode.leftId);
            if (n2 >= n) continue;
            n = n2;
            viterbiNode.prev = viterbiNode3;
        }
        viterbiNode.cost += n;
        return viterbiNode;
    }

    static {
        BOS_NODES.add(ViterbiNode.makeBOSEOS());
    }

    private final class MakeLattice
    implements WordDic.Callback {
        private final ViterbiNodeList[] nodesAry;
        private int i;
        private ViterbiNodeList prevs;
        private boolean empty = true;

        public MakeLattice(ViterbiNodeList[] viterbiNodeListArray) {
            this.nodesAry = viterbiNodeListArray;
        }

        public void set(int n) {
            this.i = n;
            this.prevs = this.nodesAry[n];
            this.nodesAry[n] = null;
            this.empty = true;
        }

        @Override
        public void call(ViterbiNode viterbiNode) {
            this.empty = false;
            int n = this.i + viterbiNode.length;
            if (this.nodesAry[n] == null) {
                this.nodesAry[n] = new ViterbiNodeList();
            }
            ViterbiNodeList viterbiNodeList = this.nodesAry[n];
            if (viterbiNode.isSpace) {
                this.nodesAry[n].addAll(this.prevs);
            } else {
                this.nodesAry[n].add(Tagger.this.setMincostNode(viterbiNode, this.prevs));
            }
        }

        @Override
        public boolean isEmpty() {
            return this.empty;
        }
    }

    static class ViterbiNodeList
    extends ArrayList<ViterbiNode> {
        ViterbiNodeList() {
        }
    }
}

