/*
  Copyright (C) 2005, Kirara 
	Special thanks to Nana

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.

*/
#ifndef __DEBUGUTIL_HPP__
#define __DEBUGUTIL_HPP__

#include <stdio.h>

#ifdef WIN32
#   include <windows.h>
#endif // WIN32

#ifndef EXIT_FAILURE
#define EXIT_FAILURE 1
#endif
#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS 0
#endif

/*==========================================
    Debug utility.
==========================================*/
inline void DebugOut(int opt, const char *format, ...)
{
#   ifdef _USERDEBUG
    if ( opt ) {
        const unsigned int bufsize = 10 * 1024 + 1;
        char *buf = new char[bufsize];
        va_list args;
        va_start(args, format);
        vsprintf(buf, format, args);
        va_end(args);
#   ifdef _MSC_VER
        OutputDebugString(buf);
#   endif // _MSC_VER
#   ifdef __APPLE__
        printf ( "%s", buf ) ;
#   endif // __APPLE__
        fprintf ( stdout, "%s", buf ) ;
        delete[] buf;
    }
#   endif // _USERDEBUG
}

inline void DebugOut(const char *format, ...)
{
#   ifdef _USERDEBUG
        const unsigned int bufsize = 10 * 1024 + 1;
        char *buf = new char[bufsize];
        va_list args;
        va_start(args, format);
        vsprintf(buf, format, args);
        va_end(args);
#   ifdef _MSC_VER
        OutputDebugString(buf);
#   endif // _MSC_VER
#   ifdef __APPLE__
        printf ( "%s", buf ) ;
#   endif // __APPLE__
        fprintf ( stdout, "%s", buf ) ;
        delete[] buf;
#   endif // _USERDEBUG
}

inline void DebugOutIndex ( const char *format, ... )
{
#   ifdef _USERDEBUG
        fprintf ( stdout, "=======================================================\n" ) ;
        const unsigned int bufsize = 10 * 1024 + 1;
        char *buf = new char[bufsize];
        va_list args;
        va_start(args, format);
        vsprintf(buf, format, args);
        va_end(args);
#   ifdef _MSC_VER
        OutputDebugString("=======================================================\n");
        OutputDebugString(buf);
        OutputDebugString("=======================================================\n");
#   endif // _MSC_VER
#   ifdef __APPLE__
        printf ( "%s", buf ) ;
#   endif // __APPLE__
        fprintf ( stdout, "%s", buf ) ;
        delete[] buf;
        fprintf ( stdout, "=======================================================\n" ) ;
#   endif // _USERDEBUG
}


inline void KAssert(int opt, const char *format, ...)
{
#   ifdef _USERDEBUG
    if ( opt ) {
        const unsigned int bufsize = 10 * 1024 + 1;
        char *buf = new char[bufsize];
        va_list args;
        va_start(args, format);
        vsprintf(buf, format, args);
        va_end(args);
#   ifdef _MSC_VER
        OutputDebugString(buf);
#   endif // _MSC_VER
#   ifdef __APPLE__
        printf ( "%s", buf ) ;
#   endif // __APPLE__
        fprintf ( stderr, "%s", buf ) ;
        delete[] buf;
        exit ( EXIT_FAILURE ) ;
    }
#   endif // _USERDEBUG
}

// for memory leak
#ifdef _DEBUG
#   include "DebugUtil.hpp"
#   ifdef WIN32
#       include <new>
#       include <memory>
#       define _CRTDBG_MAP_ALLOC
#       include <cstdlib>
#       include <stdlib.h>
#       include <crtdbg.h>
        struct ds {
            ds () {
                int tmpDbgFlag;

                _CrtSetReportMode( _CRT_ERROR, _CRTDBG_MODE_FILE );
                _CrtSetReportFile( _CRT_ERROR, _CRTDBG_FILE_STDERR );
                /*
                * Set the debug-heap flag to keep freed blocks in the
                * heap's linked list - This will allow us to catch any
                * inadvertent use of freed memory
                */
                tmpDbgFlag = _CrtSetDbgFlag(_CRTDBG_REPORT_FLAG);
                tmpDbgFlag |= _CRTDBG_LEAK_CHECK_DF;
                _CrtSetDbgFlag(tmpDbgFlag);
            }
            ~ds () {
                DebugOut ( " *============================================* \n" ) ;
                DebugOut ( " *    End of Application.                     * \n" ) ;
                DebugOut ( " *    Begin memory leak check.                * \n" ) ;
                DebugOut ( " *============================================* \n" ) ;
           }
        } ;
#   endif
#endif

// NEW}N̒`
#if defined(_DEBUG)&&defined(_CRTDBG_MAP_ALLOC)&&!defined(NEW)
#define NEW ::new(_NORMAL_BLOCK, __FILE__,__LINE__)
#else
#define NEW new
#endif

#ifdef WIN32
#   ifdef _DEBUG
#      define MEMORY_CHECK ds memory_check
#   endif //_DEBUG
#   ifndef _DEBUG
#      define MEMORY_CHECK int memory_check
#   endif // _DEBUG
#else
#   define MEMORY_CHECK int memory_check
#endif

#endif // __DEBUGUTIL_HPP__
