/*
 * alink.cpp  liunk & unlink AliceSoft archive file
 *
 * Copyright (C) 1999-  Masaki Chikama (Wren) <masaki-c@is.aist-nara.ac.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 *
 *
 *  Ver 0.1     1999-04-14 : ŏ̃o[W
 *  Ver 0.2     1999-04-15 : link̃oOtBbNX낢
 *
*/
/* $Id: alslink.c,v 1.3 1999/04/15 16:08:44 chikama Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <iostream>
#include "portab.hpp"
#include "LittleEndian.hpp"
#include "alink.hpp"
int Error ;

using namespace std ;

ALink::ALink ( const char* outname )
{
	out = NULL ;
	foutname = outname ;
}

ALink::~ALink ()
{
	/* write header */
	if ( out != NULL ) {
		fclose ( out ) ;
		out = NULL ;
	}
}

int ALink::Link ( const FileList &list )
{
    return Link ( list, list.GetSize() ) ;
}

/* ۂɃt@Cǉ */
/* ǉt@C̑傫Ԃ (round 256) */
int ALink::AppendFile(FILE *in, FILE *out, const char *name) {
	int size, hsize, i;
	char b[256];
	
	/* get size */
	fseek(in, 0, SEEK_END);
	i = size = ftell(in);
	fseek(in, 0, SEEK_SET);

	/* make dri head */
	memset(b, 0, 256);
	hsize = 16 + ((strlen(name)+1) > 16 ? strlen(name)+1 : 16);
	LittleEndian_putDW(hsize, (BYTE*)b, 0);  /* pointer  */
	LittleEndian_putDW(size,  (BYTE*)b, 4);  /* filesize */
	memcpy(b+16, name, strlen(name)); /* name */
	
	/* read flagment */
	fread(b + hsize, 256 - hsize, 1, in);
	/* write first block */
	fwrite(b, 256, 1, out);
	if (feof(in)) return 1;

	i -= (256 - hsize);
	/* file append */
	while(i) {
		memset(b, 0, 256);
		fread(b, 256, 1, in);
		fwrite(b, 256, 1, out);
		if (feof(in)) break;
		i -= 256; 
	}
	return ((size + hsize + 255) >> 8);
}

int ALink::Link ( const FileList& list, int filemax )
{
#define MAXTARGET 1
	FILE *fp_in, *fp_out[MAXTARGET];
	int i, j;
	int   disk[MAXTARGET];         /* eo̓t@C̍ő僊N   */
	int   disk_cnt[MAXTARGET];     /* eo̓t@Č݂̃N */ 
	char* pointer[MAXTARGET];      /* eo̓t@C̃|C^wb_ */
	int   tsize[MAXTARGET];        /* eo̓t@C̒ǉvt@CTCY */
	char* filemap;                 /* t@C}bv */
	int   pointer_size[MAXTARGET]; /* eo̓t@C̃|C^wb_̑傫(round 256) */
	int   filemap_size;            /* t@C}bṽwb_̑傫(round 256) */
	
	/* prepare filemap */
	filemap_size = (filemax * 3 + 255) >> 8;
	if (NULL == (filemap = (char*)malloc(filemap_size << 8))) err_msg(0);
	memset(filemap, 0, filemap_size << 8);
	
	/* prepar pointer header */
	memset(disk, 0, sizeof(int)*MAXTARGET);
	memset(disk_cnt, 0, sizeof(int)*MAXTARGET);
	for (i = 0; i < filemax; i++) {
		//j = linkinfo[i].disk;
        j = 1; 
		if (j == 0) continue;
		disk[j - 1] ++;
	}
	for (i = 0; i < MAXTARGET; i++) {
		if (disk[i] == 0) continue;
		j = ((disk[i] +2) *3 + 255) >> 8; /* pointer header size */
		if (NULL == (pointer[i] = (char*)malloc(j << 8))) err_msg(0);
		memset(pointer[i], 0, j << 8);
		pointer_size[i] = j;
		tsize[i] = j;
		LittleEndian_put3B(tsize[i], (BYTE*)pointer[i], 0); /* filemap ̈ʒu */
		tsize[i] += filemap_size;
		LittleEndian_put3B(tsize[i], (BYTE*)pointer[i], 3); /* 1Ԗڂ̃t@C̈ʒu */
	}

	/* open target file */
	i = 0;
	memset(fp_out, 0, sizeof(FILE *) * MAXTARGET);
    fp_out[0] = out ;

    /* link now */

	/* seek output file */
	for (i = 0; i < MAXTARGET; i++) {
		if (fp_out[i] != NULL) {
			fseek(fp_out[i], (pointer_size[i] << 8) + (filemap_size << 8), SEEK_SET);
		}
	}
	/* append */
	for (i = 0; i < filemax; i++) {
		int size, disk = 1 ;
		/* if noname, don't link */
		//if (linkinfo[i].disk == 0) {
        if ( filemax == 0 ) {
			filemap[i*3]    = 0;
			filemap[i*3 +1] = 0;
			filemap[i*3 +2] = 0;
			continue;
		}
		/* make path 
		if (objdir == NULL) {
			strncpy(path, linkinfo[i].name, sizeof(path));
		} else {
			strcpy(path, objdir);
			strcat(path, linkinfo[i].name);
		}*/
        fp_in = fopen(list.GetFullPath(i).c_str(), "rb");
		//disk = linkinfo[i].disk;
		/* write filemap info */
		filemap[i*3]    = disk;
		LittleEndian_putW(++disk_cnt[disk -1], (BYTE*)filemap, i*3 +1);
		/* ۂɃt@Cǉ */
        size = AppendFile(fp_in, fp_out[disk -1], list.GetRelativePath(i).c_str()) ;//linkinfo[i].name);
        printf("FileNo = %d, disk = %d, name = %s\n", i, disk, list.GetFullPath(i).c_str() ) ;//linkinfo[i].name); 
		/* |C^̍XV */
		tsize[disk -1] += size;
		LittleEndian_put3B(tsize[disk -1], (BYTE*)pointer[disk -1], (disk_cnt[disk -1]+1) *3);
		fclose(fp_in);
	}

	/* write head */
	for (i = 0; i < MAXTARGET; i++) {
		if (fp_out[i] == NULL) continue;
		fseek(fp_out[i], 0, SEEK_SET);
		fwrite(pointer[i], pointer_size[i], 256, fp_out[i]);
		fwrite(filemap   , filemap_size   , 256, fp_out[i]);
	}
    free ( filemap ) ;
    free ( pointer[0] ) ;
    return 0 ;
}

bool ALink::Init ()
{
	out = fopen ( foutname.c_str(), "wb" ) ;
	if ( out == NULL ) return false ;
	return true ;
}

void ALink::err_msg(int msg_no)
{
	static char *errormsg[]={
		"alslink : [܂",                /* 0 */
		"alslink : Nt@C܂",      /* 1 */
		"alslink : o̓t@C܂",            /* 2 */
		"alslink : VN`ł͂܂",          /* 3 */
		"alslink : ̑̃G["
	};
	printf(errormsg[msg_no]);
}
