#include "path.h"
#include <cstring>


/// ********* static members ********* ///

// f~^̒` : '/'y'\'
const Path::char_t  Path::path_delimiter[] = "/\\";


/// ********* public members ********* ///

// RXgN^
Path::Path(const char_t* path,bool fgUpdate )
: m_path(path),m_state(Path::FLAG_INVALID_PATH),m_last_name(),
  m_dir_list(NULL),m_pos_ext(Path::string_t::npos)
{
    if( path == NULL )
        return;

    m_dir_list = new FILE_INFO_LIST;

    if( fgUpdate )
        update();

}

// RXgN^
Path::Path(const string_t& path,bool fgUpdate)
: m_path(path),m_state(Path::FLAG_INVALID_PATH),m_last_name(),
  m_dir_list(NULL),m_pos_ext(Path::string_t::npos)
{

    if( path == string_t() || path.empty() )
        return;

    m_dir_list = new FILE_INFO_LIST;
    
    if( fgUpdate )
        update();
        
}

// fXgN^
Path::~Path()
{
    // fBNgXg̔j
    if( m_dir_list != NULL ){
        delete m_dir_list;
        m_dir_list = NULL; 
    }
}


// pX̌
Path& Path::operator/=(const Path& path)
{

    // t@ĈƂ́CȏύXs
    if( IsFileName() )
        return *this;

    if( IsInvalid() )           // gsȂCu
        m_path  = path.m_path ;
    else                        // słȂȂ΁C
        m_path += path.m_path ;

    // pXXV
    update();

    return *this;
}

Path& Path::operator/(const Path& src)
{
    Path path(*this);
    return path /= src;
}

// pX̕ύX
Path& Path::operator--()
{
    string_t::size_type ret;

    // O猟C
    if( ( ret = m_path.find(COMMON_PATH_DELIMITER) ) != string_t::npos ){
        m_path = m_path.substr(ret+1);
        m_pdir_name = m_pdir_name.substr(ret+1);
    }

    return *this;
}
Path& Path::operator--(int)
{
    string_t::size_type ret;

    // 납CCPKw
    if( ( ret = m_pdir_name.rfind(COMMON_PATH_DELIMITER,m_pdir_name.length()-2) ) != string_t::npos ){
        m_path = m_pdir_name;   // pXefBNgɕύX
        m_last_name = m_pdir_name.substr(ret+1);
        m_pdir_name = m_pdir_name.substr(0,ret+1);
        m_state = Path::FLAG_DIR_NAME;
    }

    return *this;
}

void Path::ChangeExtension(Path::string_t& ext,bool fgUpdate)
{
    static const char_t dot = char_t('.');

    // t@CȊOȂĈ܂ܕԂ
    if( !IsFileName() )
        return;
    
    const string_t::size_type dl = m_path.length() - m_pos_ext;

    // t@C̑݊mFsȂ
    if( !fgUpdate ){
        // gq̕ύX
        if( dl == 0 && m_path[m_pos_ext-1] != dot){
            // gq݂Ȃꍇ
            (m_path += dot) += ext;
            (m_last_name += dot) += ext;
            m_pos_ext = m_path.length() - ext.length();
        }else{
            // gqɑ݂ꍇ
            m_path.erase(m_pos_ext);
            m_last_name.erase(m_last_name.length()-dl);
            m_path += ext; m_last_name += ext;
        }
    }
    // t@C̑݊mFs
    else{
        if( dl == 0 ){
            // gq݂Ȃꍇ
            (m_path += dot) += ext;
        }else{
            // gqɑ݂ꍇ
            m_path.erase(m_pos_ext);
            m_path += ext;
        }
        update();
    }
}


// fBNgXg̍쐬
int Path::MakeDirectoryList(const char_t* card,unsigned fgSearch)
{
    string_t find_path = m_path;
    int      result    = 0;
    
    // ߋ̃f[^̓NA
    m_dir_list->clear();

    // Path͐H
    if( IsInvalid() )
        return SEARCH_FAILURE_INVALID_PATH;

    // tO̖
    if( ( fgSearch & LIST_DIRNAME_ONLY ) != 0 && (fgSearch & LIST_FILENAME_ONLY) != 0 )
        fgSearch &= ~(LIST_DIRNAME_ONLY | LIST_FILENAME_ONLY);

#ifdef _WIN32
    // Path̓fBNg?
    if( !IsFileName() ){
        find_path += card;    // J[h
    }

    WIN32_FIND_DATA fd;
    HANDLE          hFind;
    
    hFind = ::FindFirstFile((LPCTSTR)find_path.c_str(),&fd);

    // s
    if( hFind == INVALID_HANDLE_VALUE )
        return SEARCH_FAILURE_INVALID_PATH;

    do{

        // JgC[gfBNg
        if( ::strcmp(fd.cFileName,"..") == 0 || ::strcmp(fd.cFileName,".") == 0 ) continue;

        // fBNg
        if( fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY ){

            // fBNgXgǉ̑Ώۂɂ邩̔
            if( ( fgSearch & LIST_FILENAME_ONLY ) == 0 ){
                // fBNg̓o^
                m_dir_list->push_back(FILE_INFO(fd.dwFileAttributes,
                                                    SET_FILE_SIZE(fd.nFileSizeLow,fd.nFileSizeHigh),
                                                    string_t(fd.cFileName))
                                 );
            }
            // TufBNg@
            if( fgSearch & SEARCH_ALSO_SUBDIR ){
                result = makeSubDirectoryList(card,fd.cFileName,fgSearch);
                if( result != SEARCH_SUCCESS ){
                    ::FindClose(hFind);
                    return result;
                }
            }
        }
        // t@C    
        else{
            // fBNgXgǉ̑Ώۂɂ邩̔
            if( ( fgSearch & LIST_DIRNAME_ONLY ) == 0 ){
                // t@C̓o^
                m_dir_list->push_back(FILE_INFO(fd.dwFileAttributes,
                                                    SET_FILE_SIZE(fd.nFileSizeLow,fd.nFileSizeHigh),
                                                    string_t(fd.cFileName))
                                 );
            }
        }

    }while( ::FindNextFile(hFind,&fd) );

    ::FindClose(hFind);

#else
    #error give a description of the code which runs by your system.
    return SEARCH_UNDEFINED;
#endif


    return m_dir_list->empty() ? SEARCH_FAILURE_UNKNOWN : SEARCH_SUCCESS ;



}


/// ********* private members ********* ///

// pX̃Abvf[g
// tH_̏ꍇɂ́CKŌɃf~^t悤ɏC܂
void Path::update()
{
    string_t::size_type _ret = 0 , ret = string_t::npos;

    // ݊mF
    if( ( m_state = exists() ) == FLAG_INVALID_PATH){
        m_last_name = "";           // I[t@C͏
        m_pdir_name = "";           // efBNg
        m_pos_ext = string_t::npos; // gq
        return;
    }

    // path̍ŏCf~^̂ǂ炩Ɉv镔
    while( ( _ret = m_path.find_first_of(Path::path_delimiter,_ret) ) != string_t::npos ){
        m_path[_ret] = COMMON_PATH_DELIMITER;
        ret = _ret = _ret + 1; // f~^̕CNg
    }
    if( ret != string_t::npos ){
        // pXf~^ꍇ
        if( ret == m_path.length() ){
            // ŏI = pXf~^ : tH_ƔF
            m_state |= Path::FLAG_DIR_NAME ;
            // tH_𓾂邽߂ɁCreẗʒuXV
            ret = m_path.find_last_of(Path::path_delimiter,ret-2) + 1;
            // gq͖
            m_pos_ext = string_t::npos;
        }else{
            // ȊO : t@Cł邩̔s
            if( !IsFileName() ){
                // tH_̏ꍇɂ́Cf~^ǉD
                m_path += COMMON_PATH_DELIMITER;
                m_pos_ext = string_t::npos;
            }
            else{
                // t@C̏ꍇCgqʒuݒ肷
                setPosOfExtension();
            }

        }
        // Jgt@C/tH_ǉ
        m_last_name = m_path.substr(ret);
        // et@C/tH_ǉ
        m_pdir_name = m_path.substr(0,ret);
    }else{
        // pXf~^Ȃꍇ(΃pX)
        m_pdir_name = "";
        // t@C
        if( IsFileName() ){
            m_last_name = m_path;
            setPosOfExtension();
        }
        // fBNg
        else{
            // f~^̒ǉ
            m_path += COMMON_PATH_DELIMITER;
            // gq͖
            m_pos_ext = string_t::npos;
        }
    }

#if __LOST_METHOD
    string_t::size_type ret;

    // ݊mF
    if( ( m_state = exists() ) == FLAG_INVALID_PATH){
        m_last_name = "";   // I[t@C͏
        m_pdir_name = "";   // efBNg
        return;
    }

    // path̍ŌォCf~^̂ǂ炩Ɉv镔
    if( ( ret = m_path.find_last_of(Path::path_delimiter) ) != string_t::npos ){
        ret += 1;   // f~^̕CNg
        // pXf~^ꍇ
        if( ret == m_path.length() ){
            // ŏI = pXf~^ : tH_ƔF
            m_state |= Path::FLAG_DIR_NAME ;
            // tH_𓾂邽߂ɁCreẗʒuXV
            ret = m_path.find_last_of(Path::path_delimiter,ret-2) + 1;
        }else{
            // ȊO : t@Cł邩̔s
            if( !IsFileName() ){
                // tH_̏ꍇɂ́Cf~^ǉD
                m_path += m_path[ret-1];
            }
        }
        // Jgt@C/tH_ǉ
        m_last_name = m_path.substr(ret);
        // et@C/tH_ǉ
        m_pdir_name = m_path.substr(0,ret);
    }else{
        // pXf~^Ȃꍇ(΃pX)
        if( !IsFileName() ){
            m_path += Path::path_delimiter[0];
        }        
        m_last_name = m_path;
        m_pdir_name = "";
    }
#endif
}


// t@C̑݊mF
int Path::exists()const
{
#ifdef _WIN32 
    DWORD dwAttr;

    if( (dwAttr = ::GetFileAttributes((LPCTSTR)m_path.c_str())) == -1 ){
        // G[͖ȃf[^łƔF
        return Path::FLAG_INVALID_PATH; // t@C݂Ȃ
    }

    if( (dwAttr & FILE_ATTRIBUTE_DIRECTORY) != 0 ){
        // fBNg
        return Path::FLAG_DIR_NAME;
    }else
        return Path::FLAG_FILE_NAME;

#else

    #error give a description of the code which runs by your system.
    return FLAG_INVALID_PATH;

#endif // _WIN32

}

// pX̊gqʒuݒ
void Path::setPosOfExtension()
{
    static const char_t dot = char_t('.');

    if( ( m_pos_ext = m_path.find_last_of(dot) ) == string_t::npos ){
        if( IsFileName() ){
            m_pos_ext = m_path.length();
        }
    }else{
        ++m_pos_ext;
    }
}

// ċAIȃTufBNǧ
int Path::makeSubDirectoryList(const char_t* card,const Path::string_t& dirname,unsigned fgSearch)
{
    string_t _find_path  = string_t(dirname) + Path::path_delimiter[0];
    int      result      = 0;

#ifdef WIN32

    string_t  find_path  = m_path + _find_path + card;

    WIN32_FIND_DATA fd;
    HANDLE          hFind;
    
    hFind = ::FindFirstFile((LPCTSTR)find_path.c_str(),&fd);

    // s
    if( hFind == INVALID_HANDLE_VALUE )
        return SEARCH_FAILURE_INVALID_PATH;

    do{

        // JgC[gfBNg
        if( ::strcmp(fd.cFileName,"..") == 0 || ::strcmp(fd.cFileName,".") == 0 ) continue;

        // fBNg
        if( fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY ){

            // fBNgXgǉ̑Ώۂɂ邩̔
            if( ( fgSearch & LIST_FILENAME_ONLY ) == 0 ){
                // fBNg̓o^
                m_dir_list->push_back(FILE_INFO(fd.dwFileAttributes,
                                                    SET_FILE_SIZE(fd.nFileSizeLow,fd.nFileSizeHigh),
                                                    _find_path + fd.cFileName)
                                         );
            }
            // TufBNg̑
            if( fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY ){
                // gċAIɌĂяo
                result = makeSubDirectoryList(card , _find_path + fd.cFileName , fgSearch);
                if( result != SEARCH_SUCCESS ){
                    ::FindClose(hFind);
                    return result;
                }
            }

        }
        // t@C    
        else{
            // fBNgXgǉ̑Ώۂɂ邩̔
            if( ( fgSearch & LIST_DIRNAME_ONLY ) == 0 ){
                // t@C̓o^
                m_dir_list->push_back(FILE_INFO(fd.dwFileAttributes,
                                                    SET_FILE_SIZE(fd.nFileSizeLow,fd.nFileSizeHigh),
                                                    _find_path + fd.cFileName)
                                         );
            }
        }
    
    }while( ::FindNextFile(hFind,&fd) );

    ::FindClose(hFind);
#else
    #error give a description of the code which runs by your system.
    return SEARCH_UNDEFINED;
#endif

    return SEARCH_SUCCESS;

}


#if __LOST_METHOD
bool Path::compare_to_ignore_delimiter(const Path& path,std::string::size_type pos1 
                                                       ,std::string::size_type pos2,std::string::size_type n)const
{
    const char *str1 = m_path.c_str(), *str2 = path.m_path.c_str();

    if( m_path.length() <= pos1 || path.m_path.length() <= pos2 )
        return false;

    if( m_path.length() != path.m_path.length() )
        return false;



    for( string_t::size_type i = 0 ; i < m_path.length() && i < n; ++i ){

        if( m_path[i] == path.m_path[i] ) continue;

        // ͋
        if( ( m_path[i] == path_delimiter[0] || m_path[i] == path_delimiter[1] ) &&
            ( path.m_path[i] == path_delimiter[0] || path.m_path[i] == path_delimiter[1] )
          )
            continue;
        false;
    }
    return true;

}
#endif
