/* ***********************************************************************
    
    path.h
        pXǗpNX


        [History]
            2005/09/02 : * Ŋ , Lq~XC
            2005/09/15 : * fBNg擾Ɋւ郁o̒ǉ
                         * dl̔
            2005/09/16 : * fBNgɂāCt@C/tH_
                          ݂̗̂񋓂\ɂD
                         * Lq~XC
                         * GetFilePath֐GetPath֐ɖOύX
                         * update֐̐U镑̕ύX
                            -> sȃpX̏ꍇɂpX͕ێ
                         * opertor/,operator/=̐U镑ύX
                         * IsInvalid,IsFileName֐̖C
                         * RXgN^̈̕ύX
                         * operator==,operator!=̒ǉ
                            -> Ct@CwĂ邩ł͂ȂC
                               f~^ɂȂr܂Ŏ
                         * gq擾ł悤ɂD
        [comment]
            * _SUPPORT_64BIT_FILE_SIZE}N̒`ɂ64BITt@CTCY
             T|[g܂
            * __LOST_METHOD}ŃCdl̕ύXɂč폜\̃R[h
             ̃RgAEgƂĎgĂ܂D0łD

        [enviorment]
            [Windows]
            Visual C++ 6.0 Standard / Visual C++ .NET 2002
            Microsoft Windows 2000 Professional
                            / Microsoft Windows XP Home Edition


                                    @author : Fuya KIZUKA , 2005/09/02
   *********************************************************************** */
#ifndef __PATH_H__050901__
#define __PATH_H__050901__


#include <string>
#include <list>
#include <assert.h>


#ifdef _WIN32
#include <windows.h>
#else

#endif

#ifndef __USE_VERSION
#define __USE_VERSION   5091901

#define __LOST_METHOD 0

#endif  // __USE_VERSION

// t@CTCYɊւ`
#ifdef _SUPPORT_64BIT_FILE_SIZE

typedef _int64 file_size_t;
inline
file_size_t SET_FILE_SIZE(unsigned long low,unsigned long high)
    { return file_size_t( file_size_t(high) << 32 | low ); }

#else

typedef unsigned long file_size_t;
inline
file_size_t SET_FILE_SIZE(unsigned long low,unsigned long high)
    { return low; }

#endif // _SUPPORT_64BIT_FILE_SIZE 


class Path
{
public:
    // NXύXꍇ͂ύXĂ
    // Cchar^Ƃ̌݊ƂĂKv܂D
    typedef char                      char_t;
    // NXύXꍇɂ͂ύXĂ
    // Cstd::basic_string̃o֐݊NXgpĂ
    typedef std::basic_string<char_t> string_t;

    /// **** fBNgt@C擾֌W̒` **** ///
public:
    // t@Cێ\
    struct FILE_INFO
    {
        unsigned long   attribute;      // t@C 
        file_size_t     size;           // t@CTCY
        string_t        name;           // t@C
        
        // RXgN^
        FILE_INFO() : attribute(0),size(0),name(){}
        FILE_INFO(unsigned long _attribute,file_size_t _size,std::string _name)
            : attribute(_attribute),size(_size),name(_name){}
    };
    typedef std::list<FILE_INFO>           FILE_INFO_LIST;
    typedef std::list<FILE_INFO>::iterator FILE_INFO_LIST_ITER_T;

public:
    /// RXgN^/fXgN^
    Path(const char_t*,bool = true);
    Path(const string_t&,bool = true);

    ~Path();

    /// *** accessor *** ///
    const char_t* GetFileName()const;               // ݂t@C̎̂ݗL
    const char_t* GetCurrentDirectoryName()const;   // ݂fBNg̎̂ݗL
    const char_t* GetLastName()const;               // t@CCfBNgւ炸擾
    const char_t* GetDirectoryName()const;          // ݂"t@C"̐efBNg擾
    const char_t* GetParentDirectoryName()const;    // ݂̃t@C/fBNg̐efBNg擾
    const char_t* GetPath()const;                   // ݂̃pX擾
    const char_t* GetExtension()const;              // ݂̃pX̊gq擾
    bool  IsFileName()const;
    bool  IsInvalid()const;

    /// *** pX *** ///
    Path& operator/(const Path&);
    Path& operator/=(const Path&);

    /// *** ێfBNg̕ύX *** ///
    Path& operator--();     // ŏ
    Path& operator--(int);  // Ōォ(KwP)

    /// *** o^gq̕ύX *** ///
    //  **
    //      gqext'.'͕Kv܂.
    //      fgUpdatetruêƂɂ́Ct@C̑݊mFȂǂs܂.
    void ChangeExtension(string_t& ext,bool fgUpdate = false);
    void ChangeExtension(const char_t* ext,bool fgUpdate = false);

    /// *** rZq **** ///
    bool operator==(const Path& rhs)const;
    bool operator!=(const Path& lhs)const;


    /// *** fBNg֌W *** ///
public:
    // fBNgT[`ɊւtO
    //  **
    //      LIST_FILENAME_ONLYtOLIST_DIRNAME_ONLYtOꏏɐݒ肳ꂽꍇC
    //      ̓̃tO͖ƂȂCt@CƃfBNg𑖍܂D
    enum{
        SEARCH_WITHOUT_SUBDIR       = 0U,        // TufBNg𑖍Ȃ 
        SEARCH_ALSO_SUBDIR          = 1U,        // TufBNg𑖍

        LIST_FILE_AND_DIR           = 0U,        // t@CCfBNg𗼕
        LIST_FILENAME_ONLY          = 2U,        // t@Ĉ݂𑖍
        LIST_DIRNAME_ONLY           = 4U,        // fBNĝ݂𑖍
    };
    // fBNgT[`ɋAtO
    enum{
        SEARCH_FAILURE_UNDEFINED        = -1,   // ĂȂ
        SEARCH_SUCCESS                  =  0,   // ͐
        SEARCH_FAILURE_INVALID_PATH,            // ȃpX
        SEARCH_FAILURE_UNKNOWN,                 // ̂ق̃G[
    };
    // t@CXg̍쐬
    //  * ڍ *
    //      ֐0(SEARCH_SUCCESS)Ԃ܂D
    //      śC0Ԃ܂D̐lɂăG[̌킩܂D
    //      쐬ꂽt@CXǵCGetDirectoryListo֐ɂ
    //      擾ł܂D擾ꂽXg̃pXm_path̑΃pXłD
    //      <argument>
    //          card    : t@C̎
    //          fgSearch: TufBNg邩(ΏۂɂȂƂ̂)
    //
    //      !!CAUTION!!
    //          fBNgXǵCMakeDirectoryListo֐Ă΂邽тɏ܂D
    //          card"*.h"Ȃǂ͂ꍇCfBNg͌܂D
    int MakeDirectoryList(const char_t* card = "*",unsigned fgSearch = SEARCH_WITHOUT_SUBDIR | LIST_FILENAME_ONLY);
    // t@CXg̎擾
    const FILE_INFO_LIST *GetDirectoryList()const;

private:
    // TufBNgċAIɌ܂
    //  * ڍ *
    //      ̊֐́CMakeDirectoryListĂяo܂DԒlMakeDirectoryList֐ƓłD
    //      <argument>
    //          dirname: TufBNg̖O(m_path̑΃pX)
    int makeSubDirectoryList(const char_t* card,const string_t& dirname,unsigned fgSearch); 




private:
    Path(){}                     // ftHgRXgN^Ăяo֎~
    void    update();            // pX̃Abvf[g
    int     exists()const;       // pX݂邩̔(tOԂ)
    void    setPosOfExtension(); // pX̊gq̈ʒuݒ肷

    // exists֐,m_stateێtO
    enum{
        FLAG_INVALID_PATH,
        FLAG_DIR_NAME,
        FLAG_FILE_NAME,
    };

#if __LOST_METHOD
    // f~^𖳎Ĕr
    bool compare_to_ignore_delimiter(const Path& path,std::string::size_type pos1 = 0
                                                     ,std::string::size_type pos2 = 0
                                                     ,std::string::size_type n = std::string::npos)const;
    // f~^𖳎Ĕr(use STL version)
    struct _compare_to_ignore_delimiter
    {
        _compare_to_ignore_delimiter(){}
        bool operator()(const char_t lhs,const char_t rhs)const
            { return lhs == rhs || ( check_delimiter(lhs) && check_delimiter(rhs) ); }
    private:
        bool check_delimiter(const char_t ch)const
        {   for(const char_t*d = Path::path_delimiter ; d!='\0' ; ++d )
                if( ch == *d ) return true;
            return false;
        }

    };
#endif // __LOST_VERSION

private:

    string_t            m_path;         // pathi[p
    unsigned            m_state;        // Ԋi[p
    string_t            m_last_name;    // m_pathwĂt@C/fBNg
    string_t            m_pdir_name;    // m_pathwĂt@C̐efBNg
    string_t::size_type m_pos_ext;      // m_path̊gqʒu
    FILE_INFO_LIST     *m_dir_list;     // fBNg̃Xgێ

    // pX̋؂\̔z
    static const char_t  path_delimiter[];
private:
    static const size_t  path_delimiter_size;

};

#define COMMON_PATH_DELIMITER (Path::path_delimiter[0])

// inline֐̒`t@CĂяo
#include "path.inl"


#endif // __PATH_H__050901__