#ifndef __PATH_INL__050914__
#define __PATH_INL__050914__


// accessor
inline
const Path::char_t* Path::GetFileName()const
{
    return   IsFileName()
           ? m_last_name.c_str()
           : NULL
           ;
}
inline
const Path::char_t* Path::GetCurrentDirectoryName()const
{
    return   ((!IsInvalid()) & (!IsFileName()))
           ? m_last_name.c_str()
           : NULL
           ;
}
inline
const Path::char_t* Path::GetLastName()const
{
    return   (!IsInvalid())
           ? m_last_name.c_str()
           : NULL
           ;
}
inline
const Path::char_t* Path::GetDirectoryName()const
{
    return  (IsFileName())
           ? m_pdir_name.c_str()
           : NULL
           ;
}

inline
const Path::char_t* Path::GetParentDirectoryName()const
{
    return  (!IsInvalid())
           ? m_pdir_name.c_str()
           : NULL
           ;
}


inline
const Path::char_t* Path::GetPath()const
{
    return   (!IsInvalid())
           ? m_path.c_str()
           : NULL
           ;
}
inline
const Path::char_t* Path::GetExtension()const
{
    const char* ret =   (IsFileName()) && (m_pos_ext != string_t::npos)
                      ? m_path.c_str() + m_pos_ext
                      : NULL
                      ;
    return ret;
}


inline
bool Path::IsFileName()const
{
    return   (m_state == FLAG_FILE_NAME)
           ? true
           : false
           ;
}

inline
bool Path::IsInvalid()const
{
    return   (m_state == FLAG_INVALID_PATH)
           ? true
           : false
           ;
}

inline
const Path::FILE_INFO_LIST *Path::GetDirectoryList()const
{
    return m_dir_list == NULL ? NULL : ( m_dir_list->empty() ? NULL
                                                             : m_dir_list
                                       )
           ;
};

inline
void Path::ChangeExtension(const Path::char_t* ext,bool fgUpdate)
    { ext == NULL ? ChangeExtension(string_t(),fgUpdate)
                  : ChangeExtension(string_t(ext),fgUpdate)
                  ;
    }


inline
bool Path::operator==(const Path& rhs)const
{
#if __LOST_METHOD
    return ( !IsInvalid() && !rhs.IsInvalid() ) && compare_to_ignore_delimiter(rhs) ;   

    return   ( !IsInvalid() && !rhs.IsInvalid() ) && m_path.length() == rhs.m_path.length() 
           ? std::equal(m_path.begin(),m_path.end(),rhs.m_path.begin(),Path::_compare_to_ignore_delimiter())
           : false
           ;
#endif // __LOST_METHOD

    return m_path == rhs.m_path;
}

inline
bool Path::operator!=(const Path& rhs)const
{
    return !(*this == rhs);
}

#endif // __PATH_INL__050914__