class Entry < ActiveRecord::Base
	has_many :reverse_links, :foreign_key => 'to_entry_id'

	validates_uniqueness_of :body
	validates_length_of :body,  :in => 1..1024*10

	after_save :set_revlink
	after_save :save_history

	private
	def set_revlink
		self.body.scan(/>>([0-9,]+)/) {
			$1.split(/,/).each {|to_entry_id|
				next if ReverseLink.find(:first, :conditions => ['from_entry_id = ? AND to_entry_id = ?', self.id, to_entry_id])
				revlink = ReverseLink.new(:from_entry_id => self.id, :to_entry_id => to_entry_id)
				revlink.save
			}
		}
	end

	def save_history
		history = History.new(
			:entry_id  => self.id,
			:hostname  => self.hostname,
			:body      => self.body,
			:post_time => self.updated_on
		)
		history.save
	end
end
