require 'cgi'

module Formatter
	module_function :format

	InterWikiName = {
		'google'    => 'http://www.google.com/search?num=50&ie=UTF-8&lr=lang_ja&q=ARGUMENT',
		'ruby-list' => 'http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/ARGUMENT',
		'raa'       => 'http://raa.ruby-lang.org/list.rhtml?name=ARGUMENT',
		'cpan'      => 'http://search.cpan.org/perldoc?ARGUMENT',
		'isbn'      => 'http://www.amazon.co.jp/exec/obidos/ASIN/ARGUMENT/tokuhirom-22/ref=nosim',
		'asin'      => 'http://www.amazon.co.jp/exec/obidos/ASIN/ARGUMENT/tokuhirom-22/ref=nosim',
		'idea'      => 'http://i.hatena.ne.jp/idea/ARGUMENT',
		'bakaid'    => 'http://www.lostway.org/~tko/cgi-bin/bakagaiku.rb?bakaid=ARGUMENT',
		'pep'       => 'http://www.python.org/peps/pep-ARGUMENT.html',
	}

	def format(text, mobile_flag=false)
		result = CGI.escapeHTML(text).gsub(%r{(s?https?://[-_.!~*'()a-zA-Z0-9;/?:@&=+$,%#]+)}) {
			url = $1
			if !mobile_flag && url =~ /\.(jpe?g|png|bmp|gif)$/
				imgpopup(url)
			else
				%Q!<a href="#{url}">#{url}</a>!
			end
		}.gsub(/(\[([a-z\-]+):([^\n\r]+?)\])/) {
			all      = $1
			wikiname = $2
			argument = CGI.escape(CGI.unescapeHTML($3))
			if InterWikiName.has_key?(wikiname)
				"<a href='#{InterWikiName[wikiname].gsub(/ARGUMENT/, argument)}'>#{all}</a>"
			else
				all
			end
		}.gsub(/(&gt;&gt;([0-9,]+))/) {
			if mobile_flag
				"<a href='#{url_for :controller => 'index', :action => 'show', :id => $2}'>#{$1}</a>"
			else
				popup($2)
			end
		}.gsub(/\r\n|\n|\r/) {
			'<br />'
		}.gsub(%r{&gt;&gt;<br />(.+?)&lt;&lt;}m) {
			"<blockquote>#{$1}</blockquote>"
		}.gsub(%r[\{\{\{<br />(.+?)\}\}\}]m) {
			"<pre>#{$1.gsub(%r{<br />}, "\n")}</pre>"
		}
	end

	def popup(id)
		r = rand(10000)
		return %Q!<a href='#{url_for :controller => 'index', :action => 'show', :id => id}' onmouseover="new Ajax.Updater('popup#{r}', '#{url_for :controller => 'ajax', :action => 'show', :id => id}', {asynchronous:true, evalScripts:true});$('popup#{r}').style.display='block';return false;">&gt;&gt;#{id}</a><div id="popup#{r}" onmouseout="setTimeout(function () {$('popup#{r}').style.display='none'}, 3000);" style="display:none;position:absolute"></div>!
	end

	def imgpopup(imgurl)
		r = rand(10000)
		return %Q!<a href='#{imgurl}' onmouseover="$('popup#{r}').style.display='block';return false;">#{imgurl}<br /><img src="#{imgurl}" width="30" height="30" /></a><div id="popup#{r}" onclick="this.style.display='none';return false" onmouseout="setTimeout(function () {$('popup#{r}').style.display='none'}, 3000);" style="display:none;position:absolute"><img src="#{imgurl}" /></div>!
	end
end

