/******************************************************************************/
/*! @file List.cc
    @brief List class
    @author Tachibanamasashi, Apolloron Project.
 ******************************************************************************/

#include <stdio.h>
#include <string.h>
#include "apolloron.h"

namespace apolloron {

/*! Constructor of List.
    @param void
    @return void
 */
List::List() {
  (*this).pList = NULL;
  (*this).pListSize = 0;
}


/*! Copy constructor of List.
    @param list
    @return void
 */
List::List(const List & list) {
  (*this).pList = NULL;
  (*this).pListSize = 0;
  set(list);
}


/*! Destructor of List.
    @param void
    @return void
 */
List::~List() {
  (*this).clear();
}


/*! clear List.
    @param void
    @retval true  success
    @retval false failure
 */
bool List::clear() {
  long i;

  i = 0;
  while (i < (*this).pListSize) {
    delete (String *)((*this).pList[i]);
    i++;
  }
  if ((*this).pList != NULL) {
    delete [] (*this).pList;
  }
  (*this).pList = NULL;
  (*this).pListSize = 0;

  return true;
}


/*! array operator of List.
    @param index index of array
    @return String Object
 */
String& List::operator [] (long index) {
  return *((*this).pList[index]);
}


/*! array operator of List.
    @param index index of array
    @return String Object
 */
String& List::operator [] (int index) {
  return *((*this).pList[index]);
}


/*! append String into List object
    @param value  object
    @retval true  success
    @retval false failure
 */
bool List::addString(const String & value) {
  String **new_pList;

  // Replacement the list with new array
  (*this).pListSize++;
  new_pList = new String * [(*this).pListSize];
  if (0 < (*this).pListSize - 1) {
    memcpy(new_pList, (*this).pList, sizeof(String *) * ((*this).pListSize - 1));
    delete [] (*this).pList;
  }
  (*this).pList = new_pList;

  // Copy string
  (*this).pList[(*this).pListSize - 1] = new String;
  *((*this).pList[(*this).pListSize - 1]) = value;

  return true;
}


/*! delete String from List.
    @param index index of array
    @retval true  success
    @retval false failure
 */
bool List::delString(long index) {
  if (index < 0 || (*this).pListSize <= index) return false;

  // Shift one after number of array index
  (*this).pListSize--;
  delete (String *)((*this).pList[index]);

  if ((*this).pListSize <= 0) {
    delete [] (*this).pList;
    (*this).pList = NULL;
  } else {
    String **new_pList;

    new_pList = new String * [(*this).pListSize];
    if (0 < index) {
      memcpy(new_pList, (*this).pList, sizeof(String *) * index);
    }
    if (index < (*this).pListSize) {
      memcpy(&(new_pList[index]), &((*this).pList[index + 1]), sizeof(String *) * ((*this).pListSize - index));
    }
    delete [] (*this).pList;
    (*this).pList = new_pList;
  }

  return true;
}


/*! insert String into List.
    @param index  index of array
    @param value  object
    @retval true  success
    @retval false failure
 */
bool List::insertString(long index, const String & value) {
  if (index < 0 || (*this).pListSize < index) {
    return false;
  } else if ((*this).pListSize == index) {
    (*this).addString(value);
  } else {
    String **new_pList;

    // Create new array, then copy before number of array index
    (*this).pListSize++;
    new_pList = new String * [(*this).pListSize];
    if (0 < index) {
      memcpy(new_pList, (*this).pList, sizeof(String *) * index);
    }

    // Copy string
    new_pList[index] = new String;
    *(new_pList[index]) = value;

    // Copy of continuing array
    memcpy(&(new_pList[index + 1]), &((*this).pList[index]), sizeof(String *) * ((*this).pListSize - 1 - index));

    // Replace array
    if ((*this).pList != NULL) {
      delete [] (*this).pList;
    }
    (*this).pList = new_pList;

  }

  return true;
}


/*! get length of rows of List.
    @param void
    @return length of rows
 */
long List::max() const {
  return (*this).pListSize;
}


/*! merge List object
    @param list  List object
    @retval true  success
    @retval false failed
 */
bool List::set(const List & list) {
  long i;

  (*this).clear();

  i = 0;
  while (i < list.pListSize) {
    (*this).addString(*(list.pList[i]));
    i++;
  }

  return true;
}


/*! set operator of List
    @param list  List object
    @return List object
 */
const List& List::operator = (const List &list) {
  (*this).set(list);

  return *this;
}


/*! set operator of List
    @param value  List object
    @return List object
 */
const List& List::operator += (const String & value) {
  (*this).addString(value);
  return *this;
}


/*! append String into List object
    @param value  List object
    @retval true  success
    @retval false failed
 */
bool List::add(const String & value) {
  return (*this).addString(value);
}


/*! insert String into List object
    @param index  index of array
    @param value  List object
    @retval true  success
    @retval false failed
 */
bool List::insert(long index, const String & value) {
  return (*this).insertString(index, value);
}


/*! remove String from List object
    @param index  index of array
    @retval true  success
    @retval false failed
 */
bool List::remove(long index) {
  return (*this).delString(index);
}


} // namespace apolloron
