/******************************************************************************/
/*! @file CGI.cc
 *  @brief CGI class
 *  @author Tachibanamasashi, Apolloron Project.
 ******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/file.h>
#include <fcntl.h>
#include <unistd.h>
#include <ctype.h>
#include "apolloron.h"

namespace apolloron {

/*! Constructor of String.
 *  @param void
 *  @return void
 */
CGI::CGI(int argc, const char *argv[]) {
  String str;
  char buf[1024 + 1];
  const char *cpstr;
  char *pstr;

  (*this).clear();
  str.clear();
  if ((cpstr = getenv("REQUEST_METHOD")) != NULL) {
    char *p;
    strncpy(buf, cpstr, 1024);
    buf[1024]='\0';
    p = buf;
    while (*p != '\0') {
      *p = toupper(*p);
      p++;
    }

    if ( strcmp(buf, "GET") == 0 ) {
      /* GET Method */
      if ((cpstr = getenv("QUERY_STRING")) != NULL) {
        str = cpstr;
      }
    } else if (!strcmp(buf, "POST")) {
      /* POST Method */
      if ((cpstr = getenv ("CONTENT_LENGTH")) != NULL) {
        int len, getlen, getlen_pre;
        strncpy(buf, cpstr, 1024);
        buf[1024]='\0';
        len = atoi(buf);
        getlen = 0;
        pstr = new char [len + 1];
        while (getlen < len) {
          getlen_pre = getlen;
          getlen += fread(buf, 1, (len - getlen <= 1024)?(len - getlen):1024, stdin);
          buf[getlen] = '\0';
          if (0 < (getlen - getlen_pre)) {
            memcpy(pstr + getlen_pre, buf, (getlen - getlen_pre));
          }
          if (ferror(stdin)) {
            break;
          }
        }
        str.setBinary(pstr, getlen);
        delete [] pstr;
      }
    }
  }

  if (0 < str.binaryLength()) {
    int i, j, k, len;
    len = str.binaryLength();
    if ((cpstr = getenv ("CONTENT_TYPE")) != NULL && !strncmp(cpstr, "multipart/form-data", 19)) {
      // multipart request
      char *boundary;
      int ret;
      const char *head_start;
      int boundary_len, col;
      bool is_text;
      String esc_tmp_key, esc_tmp_filename;

      cpstr = strstr(cpstr, "boundary=");
      if (cpstr != NULL) {
        boundary = new char [strlen(cpstr + strlen("boundary=")) + 3];
        sprintf(boundary, "--%s", cpstr + strlen("boundary="));
        pstr = strchr(boundary, ';');
        if (pstr != NULL) {
          *pstr = '\0';
        }
      } else {
        boundary = new char [1];
        boundary[0] = '\0';
      }
      boundary_len = strlen(boundary);

      if (0 < boundary_len) {
        cpstr = str.c_str();
        col = 0;
        while (!strncmp(cpstr+col, boundary, boundary_len)) {
          char *head, *body;
          const char *cp;
          long body_len;

          if (!strncmp(cpstr+col+boundary_len, "--", 2)) {
            break;
          }

          head = NULL;
          body = NULL;
          body_len = 0;

          col += boundary_len;
          if (cpstr[col] == '\r') col++;
          if (cpstr[col] == '\n') col++;

          esc_tmp_key = "";
          esc_tmp_filename = "";
          is_text = true;

          head_start = cpstr + col;
          ret = 0;
          for (i = 0; head_start[i] != '\0'; i++) {
            if (ret == 2) {
              break;
            }
            if (head_start[i] == '\n') {
              ret++;
            } else if (head_start[i] == '\r' && head_start[i+1] == '\n') {
              i++;
              ret++;
            } else {
              ret = 0;
            }
          }
          if (ret == 2) {
            head = new char [i+1];
            strncpy(head, head_start, i);
            head[i] = '\0';
            col += i;
            if (0 < i && head[i-1] == '\n') {
              head[i-1] = '\0';
              i--;
              if (0 < i && head[i-1] == '\r') {
                head[i-1] = '\0';
                i--;
              }
            }
            if (0 < i && head[i-1] == '\n') {
              head[i-1] = '\0';
              i--;
              if (0 < i && head[i-1] == '\r') {
                head[i-1] = '\0';
                i--;
              }
            }

            if (head != NULL) {
              char *p, *p1;
              char *key = NULL;
              String tmp_key, tmp_filename;
              char *head_line;
              int ii, jj, line_len;

              ii = 0;
              while (head[ii] != '\0') {
                line_len = 0;
                for (jj = ii; head[jj] != '\0'; jj++) {
                  if (head[jj] == '\n' && (head[jj+1] == '\0' || !isspace(head[jj+1]))) {
                    jj++;
                    line_len = jj;
                    break;
                  }
                }
                if (line_len == 0) line_len = jj;

                if (0 < line_len) {
                  head_line = new char [line_len + 1];
                  strncpy(head_line, head+ii, line_len);
                  head_line[line_len] = '\0';

                  if (!strncasecmp(head_line, "Content-Disposition", 19)) {
                    if ((p = strstr(head_line, "name=")) != NULL) {
                      if (p[5] == '"' && (p1 = strchr(p+6, '"')) != NULL) {
                        key = new char [p1 - (p+5) + 1];
                        strncpy(key, p+6, p1 - (p+5) - 1);
                        key[p1 - (p+5) - 1] = '\0';
                        tmp_key = key;
                        esc_tmp_key = tmp_key.unescapeQuote();
                      } else if ((p1 = strchr(p+6, ';')) != NULL || (p1 = strchr(p+6, '\r')) != NULL || (p1 = strchr(p+6, '\n')) != NULL) {
                        key = new char [p1 - (p+5) + 1];
                        strncpy(key, p+5, p1 - (p+5));
                        key[p1 - (p+5)] = '\0';
                        tmp_key = key;
                        esc_tmp_key = tmp_key;
                      }
                      tmp_key.clear();
                      if (key != NULL) delete [] key;
                    }
                    if ((p = strstr(head_line, "filename=")) != NULL) {
                      if (p[9] == '"' && (p1 = strchr(p+10, '"')) != NULL) {
                        key = new char [p1 - (p+9) + 1];
                        strncpy(key, p+10, p1 - (p+9) - 1);
                        key[p1 - (p+9) - 1] = '\0';
                        tmp_filename = key;
                        esc_tmp_filename = tmp_filename.unescapeQuote();
                      } else if ((p1 = strchr(p+10, ';')) != NULL || (p1 = strchr(p+10, '\r')) != NULL || (p1 = strchr(p+10, '\n')) != NULL) {
                        key = new char [p1 - (p+9) + 1];
                        strncpy(key, p+9, p1 - (p+9));
                        key[p1 - (p+9)] = '\0';
                        tmp_filename = key;
                        esc_tmp_filename = tmp_filename;
                      }
                      tmp_filename.clear();
                      if (key != NULL) delete [] key;
                    }
                  } else if (!strncasecmp(head_line, "Content-Type", 12)) {
                    if (strcasestr(head_line, "text/") != 0) {
                      is_text = false;
                    }
                  }

                  if (head_line != NULL)  delete [] head_line;
                }
                ii += ((0 < line_len)?line_len:1);
              }
            }

            if (cpstr[col] == '\n') {
              col++;
            } else if (cpstr[col] == '\r' && cpstr[col+1] == '\n') {
              col += 2;
            }
            if (cpstr[col] == '\n') {
              col++;
            } else if (cpstr[col] == '\r' && cpstr[col+1] == '\n') {
              col += 2;
            }

            k = str.binaryLength();
            cp = NULL;
            for (j = col; j < k - boundary_len; j++) {
              if (cpstr[j] == boundary[0] && !strncmp(cpstr + j, boundary, boundary_len)) {
                cp = cpstr + j;
                break;
              }
            }
            if (cp != NULL) {
              body_len = (long)(cp - (cpstr+col));
              body = new char [body_len + 1];
              memcpy(body, cpstr+col, body_len);
              body[body_len] = '\0';
            } else {
              body_len = strlen(cpstr+col);
              body = new char [body_len + 1];
              memcpy(body, cpstr+col, body_len);
              body[body_len] = '\0';
            }
            if (0 < body_len && body[body_len-1] == '\n') {
              body[body_len-1] = '\0';
              body_len--;
              if (0 < body_len && body[strlen(body)-1] == '\r') {
                body[body_len-1] = '\0';
                body_len--;
              }
            }

            if (cp != NULL) {
              col = cp - cpstr;
            }
          }

          if (is_text) {
            (*this).requestData[esc_tmp_key] = body;
          } else if (0 <= body_len) {
            (*this).requestData[esc_tmp_key].setBinary(body?body:"", body_len);
          } else {
            (*this).requestData[esc_tmp_key] = "";
          }
          (*this).requestFileName[esc_tmp_key] = esc_tmp_filename;

          if (head != NULL) delete [] head;
          if (body != NULL) delete [] body;
        }
      }

      esc_tmp_key.clear();
      esc_tmp_filename.clear();
      delete [] boundary;

    } else {
      // normal request
      char *p, *prev_key, *prev_value;
      String tmp_key, esc_tmp_key;

      p = new char [len + 1];
      strcpy(p, str.c_str());
      prev_key = p;
      prev_value = NULL;
      for (i = 0; i < len; i++) {
        if (p[i] == '&') {
          p[i] = '\0';
          tmp_key = prev_key;
          esc_tmp_key = tmp_key.unescapeQuote();
          (*this).requestData[esc_tmp_key] = prev_value;
          (*this).requestData[esc_tmp_key] = (*this).requestData[esc_tmp_key].decodeURL();
          prev_key = p + i + 1;
          prev_value = NULL;
        } else if (p[i] == '=') {
          p[i] = '\0';
          prev_value = p + i + 1;
        }
      }
      if (prev_key != NULL && prev_value != NULL) {
        tmp_key = prev_key;
        esc_tmp_key = tmp_key.unescapeQuote();
        (*this).requestData[esc_tmp_key] = prev_value;
        (*this).requestData[esc_tmp_key] = (*this).requestData[esc_tmp_key].decodeURL();
      }
      free(p);
      tmp_key.clear();
      esc_tmp_key.clear();
    }
  }

  str.clear();
}


/*! Destructor of String.
 *  @param void
 *  @return void
 */
CGI::~CGI() {
  (*this).clear();
}


/*! Delete instance of CGI.
 *  @param void
 *  @retval true   success
 *  @retval false  failure
 */
bool CGI::clear() {
  return (*this).requestData.clear() && (*this).requestFileName.clear();
}


/*! Delete instance of CGI.
 *  @param key
 *  @return value of key
 */
String& CGI::getValue(const String &key, const char * src_charset, const char * dest_charset) {
  return  ((String &)((*this).requestData[key])).unescapeQuote(src_charset, dest_charset);
}


/*! Delete instance of CGI.
 *  @param key
 *  @return value of key
 */
String& CGI::getValue(const char *key, const char * src_charset, const char * dest_charset) {
  return  ((String &)((*this).requestData[key])).unescapeQuote(src_charset, dest_charset);
}


/*! Delete instance of CGI.
 *  @param key
 *  @return value of key
 */
String& CGI::getFileName(const String &key, const char * src_charset, const char * dest_charset) {
  return  ((String &)((*this).requestFileName[key])).unescapeQuote(src_charset, dest_charset);
}


/*! Delete instance of CGI.
 *  @param key
 *  @return value of key
 */
String& CGI::getFileName(const char *key, const char * src_charset, const char * dest_charset) {
  return  ((String &)((*this).requestFileName[key])).unescapeQuote(src_charset, dest_charset);
}


} // namespace apolloron
