<?php
/*
 * This file is part of INQMAN
 *
 * Copyright(c) 2008 BULLHEAD,INC. ALL RIGHTS RESERVED.
 *
 * http://www.bullhead.co.jp/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation;
 * either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * ログインフォームクラス
 *
 * @author 
 * @copyright COPYRIGHT &copy 2008 BULLHEAD,INC. ALL RIGHTS RESERVED.
 * @version 
 * @package 
 * @see AbstractForm
 */
class AccountForm extends AbstractForm
{
    
    /**
     * ユーザIDのフィールド名
     */
    const USER_ID = 'user_id';
    
    /**
     * パスワードのフィールド名
     */
    const PASSWD  = 'password';
	
	/**
	 * フィルタの設定を行う
	 * 
	 * @access protected
	 * @return Zend_Filter フィルターチェインオブジェクトを返す
	 *
	 */
	protected function _prepareFilters()
	{   
	    //ユーザIDフィールド用フィルタの設定
	    $filterUserId = new Zend_Filter();
        $filterUserId->addFilter(new Zend_Filter_StringToLower())
            ->addFilter(new Zend_Filter_StringTrim())
            ->addFilter(new Bullhead_Filter_ZenToHan())
        ;
        
        //パスワードフィールド用フィルタの設定
        $filterPassword = new Zend_Filter();
        $filterPassword->addFilter(new Zend_Filter_StringTrim());
        
        //フィルタチェインの設定
        $filters = array(self::USER_ID  => $filterUserId,
                         self::PASSWD   => $filterPassword,
        );
        
        return $filters;
	}
	
	/**
	 * バリデータの設定を行う
	 * 
	 * @access public
	 * @return Zend_Validate バリデータチェインオブジェクトを返す
	 *
	 */
	protected function _prepareValidators()
	{
	    //ユーザIDフィールドのバリデータ設定
	    $validUserId = new Zend_Validate();
        $validUserId->addValidator(new Zend_Validate_NotEmpty(), true)
                ->addValidator(new Zend_Validate_StringLength(4,30))
                ->addValidator(new Zend_Validate_Regex('/^[a-zA-Z]+[0-9a-zA-Z_]+$/'))
        ;
        
        //パスワードフィールドのバリデータ設定
        $validPassword = new Zend_Validate();
        $validPassword->addValidator(new Zend_Validate_NotEmpty(), true)
                ->addValidator(new Zend_Validate_StringLength(6,20))
                ->addValidator(new Zend_Validate_Regex('/^[0-9a-zA-Z()`~!@#$%^&*_+\-={}|:;<>,.?]+$/'))
        ;
        
        //バリデータチェインの設定
        $validators = array(self::USER_ID   => $validUserId,
                            self::PASSWD    => $validPassword,
        );
        
        return $validators;
	}

}
