<?php
/*
 * This file is part of INQMAN
 *
 * Copyright(c) 2008 BULLHEAD,INC. ALL RIGHTS RESERVED.
 *
 * http://www.bullhead.co.jp/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation;
 * either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 問い合わせ登録のフォームクラス
 * 
 *
 */
class Inqman_InquiryForm extends AbstractForm
{
    const ID             = 'id';
    const SUBJECT        = 'subject';
    const CONTENT        = 'content';
    const RECEIVED_FROM  = 'received_from';
    const CREATE_DAY     = 'create_datetime';
    const ACCEPT_DAY     = 'accept_datetiem';
    const APPROVAL_DAY   = 'approval_datetime';
    const REP_LIMIT_DAY  = 'replylimit_datetime';
    const SUSPENSION_DAY = 'suspension_datetime';
    const SOLUTION_DAY   = 'solution_datetime';
    const STATUS         = 'status';
    const PRIORITY       = 'priority';
    const SERVICE_ID     = 'service_id';
    const NUMBER         = 'number';
    const OPERATOR_ID    = 'operator_id';
    const PARENT_INQ_ID  = 'parent_inquiry_id';
    const CUSTOMER_ID    = 'customer_id';
    const MEMO           = 'memo';
	
    /**
     * @see AbstractForm::_prepareFilters()
     *
     */
    protected function _prepareFilters() 
    {
    }
	
    /**
     * @see AbstractForm::_prepareValidators()
     *
     */
    protected function _prepareValidators() {
        $validators = array();
        $validate_config = $this->_config->validate->inquiry;
        
        $fieldValidator = new Zend_Validate();
        $validators[self::ID] = $fieldValidator;
        
        //件名のバリデーション設定
        $fieldValidator = new Zend_Validate();        
        $fieldValidator
                    ->addValidator(new Zend_Validate_NotEmpty(), true)
                    ->addValidator(new Zend_Validate_StringLength(0, $validate_config->subject->get('max_length', 200)))
        ;
        $validators[self::SUBJECT] = $fieldValidator;
        
        //FROMフィールドのバリデーション設定
        $fieldValidator = new Zend_Validate();
        $fieldValidator
                    ->addValidator(new Zend_Validate_StringLength(0, $validate_config->received_from->get('max_length', 200)))
        ;
        $validators[self::RECEIVED_FROM] = $fieldValidator;
        
        //内容のバリデーション設定
        $fieldValidator = new Zend_Validate();
        $fieldValidator
                    ->addValidator(new Zend_Validate_NotEmpty(), true)
                    ->addValidator(new Zend_Validate_StringLength(0, $validate_config->content->get('max_length', 2000)))
        ;
        $validators[self::CONTENT] = $fieldValidator;
        
        //重要度のバリデーション設定
        $fieldValidator = new Zend_Validate();
        $fieldValidator
                    ->addValidator(new Zend_Validate_NotEmpty(), true)
                    ->addValidator(new Zend_Validate_Int())
        ;
        $validators[self::PRIORITY] = $fieldValidator;
        
        //サービスIDのバリデーション設定
        $fieldValidator = new Zend_Validate();
        $fieldValidator
                    ->addValidator(new Zend_Validate_NotEmpty(), true)
                    ->addValidator(new Zend_Validate_Int())
        ;
        $validators[self::SERVICE_ID] = $fieldValidator;
        
        $fieldValidator = new Zend_Validate();
        $validators[self::PARENT_INQ_ID] = $fieldValidator;

        return $validators;
    }

}
