<?php
/*
 * This file is part of INQMAN
 *
 * Copyright(c) 2008 BULLHEAD,INC. ALL RIGHTS RESERVED.
 *
 * http://www.bullhead.co.jp/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation;
 * either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

require_once 'Zend/Validate/Abstract.php';
require_once 'Zend/Validate/Regex.php';
require_once 'Zend/Validate/StringLength.php';

class Inqman_Validate_Password extends Zend_Validate_Abstract  
{
    protected $_min = 6;
    protected $_max = 20;
    
    /**
     * 
     */
    public function __construct($min=null, $max=null)
    {        
        if ($min != null) $this->_min = $min;
        if ($max != null) $this->_max = $max;        
    }
    
    /**
     * @var array
     */
    protected $_messageTemplates = array(
        Zend_Validate_StringLength::TOO_SHORT => "too short",
        Zend_Validate_StringLength::TOO_LONG  => "too long",
        Zend_Validate_Regex::NOT_MATCH        => "not match",
    );
    
    /**
     * @var array
     */
    protected $_messageVariables = array(
        'min' => '_min',
        'max' => '_max'
    );
	
	/**
	 * @see Zend_Validate_EmailAddress::isValid()
	 *
	 * @param string $value
	 * @return boolean
	 */
	public function isValid($value)
	{
	    $this->_setValue($value);
	    
	    if (!empty($value)) {
	        
	        $validator = new Zend_Validate_StringLength($this->_min, $this->_max);
	        $isValid = $validator->isValid($value);
	        if (!$isValid) {
	            foreach ($validator->getErrors() as $mess) {
	                $this->_error($mess);
	            }
	        }
	        
	        $validator = new Zend_Validate_Regex('/^[0-9a-zA-Z()`~!@#$%^&*_+\-={}|:;<>,.?]+$/');
	        $isValid = $validator->isValid($value);
	        if (!$isValid) {
                foreach ($validator->getErrors() as $mess) {
                    $this->_error($mess);
                }
            }
	    }
	    
	    if (count($this->_messages) > 0) {
	        return false;
	    }
	    return true;
	}
}
