<?php
require_once 'Zend/Acl.php';
require_once 'Zend/Acl/Role.php';
require_once ROOT_DIR . '/application/models/dao/Authority.php';
require_once ROOT_DIR . '/application/models/dao/Privilege.php';
require_once ROOT_DIR . '/application/models/dao/AuthorityPrivilege.php';

class CustomZF_Acl_From_Dbtable extends Zend_Acl
{
    
    private static $_instance = null;
    
    public static function _getInstance() {
        
        if (null === self::$_instance) {
            echo "create acl instance!";
            
            $_acl = new self();
//            $_acl = new Zend_Acl();
            $authority_table = new Authority();
            $authority_const = $authority_table->select()->where('deleted <> ?', 1)
                                                         ->order('id ASC');
            $authority_rowset = $authority_table->fetchAll($authority_const);
            foreach ($authority_rowset as $row) {
                $authaction_rowset = $row->findManyToManyRowset('Authaction', 'AuthorityAuthaction');
                $authaction_list = $authaction_rowset->toArray();    
                $_acl->addRole(new Zend_Acl_Role("role_" . $row->id));
                $_acl->allow("role_" . $row->id, null, "public");
                foreach ($authaction_list as $authaction) {
                    $_acl->allow("role_" . $authaction['authority_id'], null, "allow_" . $authaction['authaction_id']);
                }
            }
            
            self::$_instance = $_acl;
        } else {
                echo "acl instance exists!!!! ";
        }
        return self::$_instance;
        
    }
    
}

?>