<?php
/**
 * Daytype Management
 *
 */
require_once (dirname(__FILE__) . "/ADMIN_Controller.php");

class Daytype extends ADMIN_Controller {

    /**
     * 日程はA,B,C,D,Zの5つ
     * A ... オフシーズン 通常(平日)
     * B ... オンシーズン 土日祝
     * C ... 特別1
     * D ... 特別2
     * Z ... 休館日
     * daytypeテーブルにデータがないときはA日程として扱う。
     * 
     */
    function Daytype()
    {
        parent::ADMIN_Controller();
        $this->load->model('User_model');
    }
    
    public function index()
    {
        $this->load->helper(array('form', 'url'));
        
        // 今月yyyymmの取得
        $today = date('Ym');
        $year = substr($today, 0, 4);
        $month = substr($today, 4, 2);
        redirect('admin/daytype/set/' . $year . '/' . $month);
    }
    
    public function set($year, $month)
    {
        $this->load->helper(array('form', 'url'));
        $this->load->model('Res_model');
        
        // submitボタンが押されている場合
        if (isset($_POST['submit']))
        {
            $this->Res_model->lock();
            
            //var_dump($_POST);
            foreach ($_POST['d'] as $key => $value)
            {
                //echo $key . ':' . $value . "<br />\n";
                $ymd = sprintf("%04d-%02d-%02d", $year, $month, $key);
                if ($value == 'A')
                {
                    $this->db->delete('daytype', array('day' => $ymd));
                }
                else
                {
                    // update or insert
                    $query = $this->db->get_where('daytype', array('day' => $ymd));
                    if ($query->num_rows() > 0)
                    {
                        $this->db->where('day', $ymd);
                        $this->db->update('daytype', array('value' => $value)); 
                    }
                    else
                    {
                        $data = array(
                                'day' => $ymd,
                                'value' => $value);
                        $this->db->insert('daytype', $data); 
                    }
                }
            }
            
            $this->Res_model->unlock();
            
        }
        
        ob_start();
        
        $prefs = array (
                       'show_next_prev'  => TRUE,
                       'next_prev_url'   => site_url('admin/daytype/set/')
                     );
        
        $prefs['template'] = '
           {table_open}<table width="100%" border="1px" cellpadding="0" cellspacing="0">{/table_open}
           {heading_row_start}<tr>{/heading_row_start}
           {heading_previous_cell}<th><a href="{previous_url}">&lt;&lt;</a></th>{/heading_previous_cell}
           {heading_title_cell}<th colspan="{colspan}">{heading}</th>{/heading_title_cell}
           {heading_next_cell}<th><a href="{next_url}">&gt;&gt;</a></th>{/heading_next_cell}
           {heading_row_end}</tr>{/heading_row_end}
           {week_row_start}<tr>{/week_row_start}
           {week_day_cell}<td>{week_day}</td>{/week_day_cell}
           {week_row_end}</tr>{/week_row_end}
           {cal_row_start}<tr>{/cal_row_start}
           {cal_cell_start}<td>{/cal_cell_start}
           {cal_cell_content}{day}<br />{content}{/cal_cell_content}
           {cal_cell_content_today}<div class="highlight">{day}<br />{content}</div>{/cal_cell_content_today}
           {cal_cell_no_content}{day}{/cal_cell_no_content}
           {cal_cell_no_content_today}<div class="highlight">{day}</br /></div>{/cal_cell_no_content_today}
           {cal_cell_blank}&nbsp;{/cal_cell_blank}
           {cal_cell_end}</td>{/cal_cell_end}
           {cal_row_end}</tr>{/cal_row_end}
           {table_close}</table>{/table_close}
        ';
        
        $this->load->library('calendar', $prefs);
        
        $cal_data = array();
        
        //echo $this->calendar->generate($this->uri->segment(4), $this->uri->segment(5));
        
        // 月の日数
        $days = date('t', mktime(0, 0, 0, $month, 1, $year));
        
        echo form_open('admin/daytype/set/' . $year . '/' . $month);
        echo "\n";
        
        $options = array(
                          'A' => 'A',
                          'B' => 'B',
                          'C' => 'C',
                          'D' => 'D',
                          'Z' => 'Z'
                        );
        
        for ($i = 1; $i <= $days; $i++)
        {
            $default = 'A';     // daytypeテーブルにないときはA日程とする。
            
            // $d . $i のデータがdaytypeテーブルにあればそれを初期値とする
            $ymd = sprintf("%04d-%02d-%02d", $year, $month, $i);
            $this->db->where('day', $ymd);
            $query = $this->db->get('daytype', 1);
            if ($query->num_rows() > 0)
            {
                $data = $query->row_array();
                $default = $data['value'];
            }
            $sss = form_dropdown('d[' . $i . ']', $options, $default);
            $cal_data[$i] = $sss;
        }
        
        //var_dump($cal_data);
        echo $this->calendar->generate($this->uri->segment(4), $this->uri->segment(5), $cal_data);
        
        echo form_submit('submit', '日程を更新する');
        echo form_close();
        
        echo 'A:オフシーズン, B:オンシーズン, C:特定日1, D:特定日2, Z:休館日' . "<br />\n";
        
        $data['contents'] = ob_get_contents();
        ob_end_clean();
        $this->load->vars($data);
        
        $this->load->view('admin/daytype/set');
    }
}
