<?php
/**
 * Login
 *
 */
class Login extends Controller {

    function Login()
    {
        parent::Controller();
    }
    
    public function index()
    {
        // ログイン処理をし、indexページに戻る。
        $this->load->library('phpsession');
        $this->load->helper(array('form', 'url'));
        $data['title'] = "login";
        $data['headline'] = "";
        $this->load->vars($data);
        
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        
        $this->form_validation->set_rules('email', 'メールアドレス', 'trim|required|xss_clean');
        $this->form_validation->set_rules('password', 'パスワード', 'trim|required|xss_clean');
        
        if ($this->form_validation->run() == FALSE)
        {
            $this->load->view('admin/login/index');
        }
        else
        {
            $email = set_value('email');
            $password = set_value('password');
            
            // email, passwordをチェックする
            $this->db->where('email', $email);
            $this->db->where('password', sha1($password));
            $this->db->where('status', 2);
            $this->db->where('usertype', 'admin');
            $query = $this->db->get('users', 1);
            if ($query->num_rows() > 0)
            {
                $row = $query->row_array();
                $this->phpsession->save('admin',
                    array('userid' => $row['userid'],
                          'name' => $row['name'],
                          'email' => $row['email'],
                          'usertype' => $row['usertype'],
                          'hotelid' => $row['hotelid']));
                // 最終ログイン日時を更新する
                $data = array('last_login' => date("Y-m-d H:i:s"));
                $this->db->where('userid', $row['userid']);
                $this->db->update('users', $data);
                redirect('admin/res');
            }
            else
            {
                $data['error'] = array();
                $data['error'][] = 'メールアドレス、またはパスワードが間違っています。';
                $this->load->vars($data);
                $this->load->view('admin/login/index');
            }
        }
    }
}
