<?php
/**
 * VacantRooms Management
 * @package     ci-hotel
 * @author      Teruki Hosokawa <hosotk@gmail.com>
 * @license     New BSD License
 */
require_once (dirname(__FILE__) . "/ADMIN_Controller.php");

class VacantRooms extends ADMIN_Controller {

    function VacantRooms()
    {
        parent::ADMIN_Controller();
        $this->load->model('User_model');
        $this->load->model('Common_model');
        $this->load->model('Res_model');
    }
    
    public function index($roomtypeid)
    {
        $this->load->helper(array('form', 'url'));
        
        // 今月yyyymmの取得
        $today = date('Ym');
        $year = substr($today, 0, 4);
        $month = substr($today, 4, 2);
        redirect('admin/vacantrooms/set/' . $roomtypeid . '/' . $year . '/' . $month);
    }
    
    public function set($roomtypeid, $year, $month)
    {
        $this->load->helper(array('form', 'url'));
        
        $this->db->where('roomtypeid', $roomtypeid);
        $query = $this->db->get('roomtypes', 1);
        if ($query->num_rows() <= 0)
        {
            die();
        }
        $roomtype = $query->row_array();
        
        // submitボタンが押されている場合
        if (isset($_POST['submit']))
        {
            $this->Res_model->lock();
            
            foreach ($_POST['d'] as $key => $value)
            {
                //echo $key . ':' . $value . "<br />\n";
                $ymd = sprintf("%04d-%02d-%02d", $year, $month, $key);
                if ($value == 'default')
                {
                    // 
                }
                else
                {
                    // update or insert
                    $query = $this->db->get_where('vacantrooms', array('day' => $ymd, 'roomtypeid' => $roomtypeid));
                    if ($query->num_rows() > 0)
                    {
                        $this->db->where('day', $ymd);
                        $this->db->where('roomtypeid', $roomtypeid);
                        $this->db->update('vacantrooms', array('vr_num' => $value)); 
                    }
                    else
                    {
                        $data = array(
                                'day' => $ymd,
                                'roomtypeid' => $roomtypeid,
                                'vr_inuse' => 0,
                                'vr_num' => $value);
                        $this->db->insert('vacantrooms', $data);
                    }
                }
            }
            
            $this->Res_model->unlock();
        }
        
        ob_start();
        
        echo '<h2>'. "部屋タイプ :" . $roomtype['roomtype_name'] . '</h2>' . "\n";
        echo '期間 :' . $roomtype['start_date'] . '～' . $roomtype['end_date'] . "<br />\n";
        
        $prefs = array (
                       'show_next_prev'  => TRUE,
                       'next_prev_url'   => site_url('admin/vacantrooms/set/' . $roomtypeid)
                     );
        $prefs['template'] = '
           {table_open}<table width="100%" border="1px" cellpadding="0" cellspacing="0">{/table_open}
           {heading_row_start}<tr>{/heading_row_start}
           {heading_previous_cell}<th><a href="{previous_url}">&lt;&lt;</a></th>{/heading_previous_cell}
           {heading_title_cell}<th colspan="{colspan}">{heading}</th>{/heading_title_cell}
           {heading_next_cell}<th><a href="{next_url}">&gt;&gt;</a></th>{/heading_next_cell}
           {heading_row_end}</tr>{/heading_row_end}
           {week_row_start}<tr>{/week_row_start}
           {week_day_cell}<td>{week_day}</td>{/week_day_cell}
           {week_row_end}</tr>{/week_row_end}
           {cal_row_start}<tr>{/cal_row_start}
           {cal_cell_start}<td>{/cal_cell_start}
           {cal_cell_content}{day}<br />{content}{/cal_cell_content}
           {cal_cell_content_today}<div class="highlight">{day}<br />{content}</div>{/cal_cell_content_today}
           {cal_cell_no_content}{day}{/cal_cell_no_content}
           {cal_cell_no_content_today}<div class="highlight">{day}</br /></div>{/cal_cell_no_content_today}
           {cal_cell_blank}&nbsp;{/cal_cell_blank}
           {cal_cell_end}</td>{/cal_cell_end}
           {cal_row_end}</tr>{/cal_row_end}
           {table_close}</table>{/table_close}
        ';
        
        $this->load->library('calendar', $prefs);
        
        $cal_data = array();
        
        // 月の日数
        $days = date('t', mktime(0, 0, 0, $month, 1, $year));
        
        echo form_open('admin/vacantrooms/set/' . $roomtypeid . '/' . $year . '/' . $month);
        echo "\n";
        
        $options = array();
        $options['default'] = '-';
        for ($i = 0; $i <= 99; $i++)
        {
            $options[$i] = $i;
        }
        
        for ($i = 1; $i <= $days; $i++)
        {
            $default = 'default';
            // $roomtypeid, $year-$month-$iのデータがvacantroomsテーブルにあればそれを初期値とする
            $ymd = sprintf("%04d-%02d-%02d", $year, $month, $i);
            $this->db->where('day', $ymd);
            $this->db->where('roomtypeid', $roomtypeid);
            $query = $this->db->get('vacantrooms', 1);
            if ($query->num_rows() > 0)
            {
                $data = $query->row_array();
                $vr_inuse = $data['vr_inuse'];
                $vr_num = $data['vr_num'];
                $default = $data['vr_num'];
                $sss = form_dropdown('d[' . $i . ']', $options, $default);
                $sss .= "<br />";
                $sss .= $vr_inuse . '/' . $vr_num . "<br />";
            }
            else
            {
                $default = 'default';
                $sss = form_dropdown('d[' . $i . ']', $options, $default);
                $sss .= "<br />";
                $sss .= '-/-' . "<br />";
            }
            $cal_data[$i] = $sss;
        }
        
        echo $this->calendar->generate($this->uri->segment(5), $this->uri->segment(6), $cal_data);
        
        echo form_submit('submit', '空き部屋数を更新する');
        echo form_close();
        
        $data['contents'] = ob_get_contents();
        ob_end_clean();
        $this->load->vars($data);
        
        $this->load->view('admin/vacantrooms/set');
    }
}
