﻿namespace Editor
{
    class CommandListHistoryIterator
    {
        readonly CommandListHistory _history;
        int _position;

        internal CommandListHistoryIterator(CommandListHistory history)
        {
            _history = history;
        }
        internal CommandListHistoryIterator(CommandListHistory history, bool isEnd)
        {
            if(isEnd)
            {
                _history = history;
                _position = _history.Count - 1;
            }
            else
            {
                _history = history;
            }
        }
        internal string GetValue()
        {
            if (_position < 0 || _history.Count <= _position)
            {
                return "";
            }
            return _history[_position];
        }

        internal void Increment()
        {
            _position++;
            if (_position >= _history.Count)
            {
                _position = _history.Count - 1;
            }
        }

        internal void Decrement()
        {
            _position--;
            if (_position < 0)
            {
                _position = 0;
            }
        }

        internal bool IsEnd()
        {
            return _position >= _history.Count;
        }
        internal bool IsBegin()
        {
            return _position <= 0;
        }
    }
}
