using System;
using System.Text.RegularExpressions;
using System.Collections.Generic;
using System.Text;

namespace Editor.DefaultParser
{
    public class Expression : ILexical
    {
        internal static Expression Parse(string text)
        {
            string tmp = text;
            //""ň͂ꂽ
            Regex textRegex = new Regex("\"[^\"\\r\\n]*\"");
            tmp = textRegex.Replace(tmp,
                                    delegate(Match match)
                                    { return string.Format("{0}", new string('T', match.Length - 2)); });

            //''ň͂ꂽ
            Regex textRegex2 = new Regex("'[^'\\r\\n]*'");
            tmp = textRegex2.Replace(tmp,
                                     delegate(Match match)
                                     { return string.Format("{0}", new string('t', match.Length - 2)); });

            //"܂'Ō܂
            Regex textRegex3 = new Regex("[\"\'].*$");
            tmp = textRegex3.Replace(tmp, 
                                    delegate(Match match)
                                    { return string.Format("{0}", new string('t', match.Length - 1)); });

            //()Ɉ͂ꂽ
            Regex parentheticRegex = new Regex(@"\([^\(\)]*\)");
            while (parentheticRegex.IsMatch(tmp))
            {
                tmp = parentheticRegex.Replace(tmp,
                                               delegate(Match match)
                                                   {
                                                       return string.Format("{0}{1}{2}", "s",
                                                                            new string('p', match.Length - 2), "t");
                                                   });
            }
            //[]Ɉ͂ꂽ
            Regex parentheticLargeRegex = new Regex(@"\[[^\)]+\]");
            while (parentheticLargeRegex.IsMatch(tmp))
            {
                tmp = parentheticLargeRegex.Replace(tmp,
                                                    delegate(Match match)
                                                        {
                                                            return string.Format("y{0}z",
                                                                                 new string('P', match.Length - 2));
                                                        });
            }

            int startPoint = 0;
            for (int i = tmp.Length - 1; i >= 0; i--)
            {
                if ((IsSymbol(tmp[i]) || Char.IsWhiteSpace(tmp[i])) && tmp[i] != '.' && tmp[i] != '' && tmp[i] != 's' && tmp[i] != 't' && tmp[i] != 'y' && tmp[i] != 'z')
                {
                    startPoint = i + 1;
                    break;
                }
            }

            Expression exp = new Expression();

            string expressionText = tmp.Substring(startPoint);
            string[] eList = expressionText.Split('.');
            int indexCounter = startPoint;
            foreach (var str in eList)
            {
                ILexical lex;
                if(str.IndexOf("y")>=0)
                {
                    lex = ClassArray.Parse(text.Substring(indexCounter, str.Length));
                }
                else if (str.IndexOf("s") >= 0)
                {
                    lex = Method.Parse(text.Substring(indexCounter, str.Length));
                }
                else if (str.IndexOf("") >= 0)
                {
                    lex = TextToken.Parse(text.Substring(indexCounter, str.Length));
                }
                else
                {
                    lex = Class.Parse(text.Substring(indexCounter, str.Length));
                }
                exp._list.Add(lex);
                indexCounter += lex.Length + 1;
            }
            return exp;
        }

        private static bool IsSymbol(char p)
        {
            return Array.IndexOf(_operatorList, p) >= 0;
        }

        internal int Count { get { return _list.Count; } }
        internal ILexical this[int index] { get { return _list[index]; } }

        #region ILexical o

        public int Length
        {
            get
            {
                int length = 0;
                foreach (var lexical in _list)
                {
                    length += lexical.Length;
                }
                return length + _list.Count - 1;
            }
        }

        public string Text
        {
            get
            {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < _list.Count; i++)
                {
                    var lex = _list[i];
                    stringBuilder.Append(lex.Text);
                    if (i != _list.Count - 1)
                    {
                        stringBuilder.Append(".");
                    }
                }

                return stringBuilder.ToString();
            }
        }

        #endregion

        internal string TextWithoutSpace
        {
            get { return Text.Trim(); }
        }

        internal string[] ToStringArray(int index, int count)
        {
            List<string> strList = new List<string>();
            for (int i = 0; i < count; i++)
            {
                var lexical = _list[i + index];
                strList.Add(lexical.Text);
            }
            return strList.ToArray();
        }

        internal void ReplaceLastToken(string replaceText)
        {
            int startSpace = 0;
            int endSpace = 0;
            if(_list.Count!=0)
            {
                string removeText = _list[_list.Count - 1].Text;
                _list.RemoveAt(_list.Count - 1);

                for (int i = 0; i < removeText.Length; i++)
                {
                    if (Char.IsWhiteSpace(removeText[i]))
                    {
                        startSpace++;
                    }
                    else
                    {
                        break;
                    }
                }
                for (int i = 0; i < removeText.Length; i++)
                {
                    if (Char.IsWhiteSpace(removeText[removeText.Length - 1 - i]))
                    {
                        endSpace++;
                    }
                    else
                    {
                        break;
                    }
                }
            }
            _list.Add(Class.Parse(new string(' ', startSpace) + replaceText + new string(' ', endSpace)));
        }

        private List<ILexical> _list = new List<ILexical>();


        private static int[] _operatorList = new int[]
                                          {
                                              '(',
                                              ')',
                                              '[',
                                              ']',
                                              '{',
                                              '}',
                                              '@',
                                              ',',
                                              ':',
                                              '.',
                                              '`',
                                              '=',
                                              ';',
                                              '+',
                                              '-',
                                              '*',
                                              '/',
                                              '%',
                                              '&',
                                              '|',
                                              '^',
                                              '>',
                                              '<',
                                              '\'',
                                              '\"',
                                              '#',
                                              '\\',
                                              '$',
                                              '?'
                                          };

    }
}