﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Editor.DefaultParser
{
    internal class ParseResult : IParseResult
    {
        private IIntelisenceDictionary _dictionary;
        Sentence _sentence = new Sentence();
        internal ParseResult(IIntelisenceDictionary dictionary, Sentence sentence)
        {
            _dictionary = dictionary;
            _sentence = sentence;
        }

        internal string[] GetPickUpTokens()
        {
            return _sentence.Expression.ToStringArray(0, _sentence.Expression.Count - 1);
        }
        internal string[] GetHelpTokens()
        {
            return _sentence.Expression.ToStringArray(0, _sentence.Expression.Count);
        }


        #region IParseResult メンバ

        public bool IsShowIntelisence()
        {
            if (_sentence.Expression.TextWithoutSpace == "")
            {
                return false;
            }
            if(!(_sentence.ExpressionLastToken is Class) )
            {
                return false;
            }
            return true;
        }


        public string GetWord()
        {
            return _sentence.Expression[_sentence.Expression.Count - 1].Text.Trim();
        }

        public string Text
        {
            get { return _sentence.Text; }
        }

        public int Replace(string selectedItem)
        {
            _sentence.Expression.ReplaceLastToken(selectedItem);
            return _sentence.Before.Length + _sentence.Expression.Length;
        }

        public bool IsShowHelp
        {
            get
            {
                int count = 0;
                for (int i = 0; i < _sentence.Before.Text.Length; i++)
                {
                    if (_sentence.Before.Text[i] == '(')
                    {
                        count++;
                    }
                    else if(_sentence.Before.Text[i] == ')')
                    {
                        count--;
                    }
                }
                return count >0;
            }
        }

        #endregion
    }
}
