﻿using System;
using System.IO;

namespace Editor
{
    public class EventMemoryStream : MemoryStream
    {
        public event EventHandler Wrote;
        private void OnWrote()
        {
            if (Wrote != null)
            {
                Wrote(this, new EventArgs());
            }
        }
        public override void Write(byte[] buffer, int offset, int count)
        {
            base.Write(buffer, offset, count);
            OnWrote();
        }
    }
}
