﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;

namespace Editor
{
    class HelpController
    {
        bool _visible = false;
        string _helpText = "";
        IHelpWindow _helpWindow;
        Point _location = new Point();

        internal void SetText(HelpContentCollection helps)
        {
            _helpWindow.SetText(helps);
        }
        internal bool Visible
        {
            get { return _visible; }
            set
            {
                _visible = value;
                _helpWindow.SetVisible(_visible);
            }
        }

        internal void Injection(IHelpWindow window)
        {
            _helpWindow = window;
        }

        internal void SetWindowPos(System.Drawing.Point point)
        {
            Point pos = Win32.GetCaretPosition();
            _location = new Point(point.X + pos.X, point.Y);
            _helpWindow.SetLocation(_location);
        }
    }
}
