﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;

namespace Editor
{
    class IntelisenceController
    {
        IIntelisenceWindow _window;

        int _selectedIndex = -1;
        bool _visible = false;
        Point _location = new Point();
        bool _isAutoSelect = false;
        bool _isSelected = false;

        bool _isCompleteMatch;
        string[] _list = new string[0];

        internal void Injection(IIntelisenceWindow window)
        {
            _window = window;
        }

        private void OnUpdated()
        {
            IntelisenceStatus status = new IntelisenceStatus();
            status.IsAutoSelect = _isAutoSelect;
            status.IsSelected = _isSelected;
            status.Location = _location;
            status.SelectedIndex = _selectedIndex;
            status.Visible = _visible;
            _window.ChangeStatus(status);
        }
        private void OnListUpdated()
        {
            _window.ChangeList(_list);
        }

        internal string GetSelectedString()
        {
            if (_isCompleteMatch && _selectedIndex != -1)
            {
                return _list[_selectedIndex];
            }
            else
            {
                return "";
            }
        }

        internal void SetList(string[] list)
        {
            _selectedIndex = -1;
            _isAutoSelect = false;
            _isSelected = false;
            _list = list;
            OnListUpdated();
        }

        internal void EditChanged(string editText)
        {
            _isCompleteMatch = false;
            for (int i = 0; i < _list.Length; i++)
            {
                if (editText.CompareTo(_list[i]) <= 0)
                {
                    _selectedIndex = i;
                    if (_list[i].StartsWith(editText))
                    {
                        _isCompleteMatch = true;
                        _isSelected = true;
                    }
                    else
                    {
                        _isSelected = false;
                    }
                    _isAutoSelect = true;
                    break;
                }
            }

            OnUpdated();
        }

        internal void ScrollTo(int n)
        {
            if (_visible == false)
            {
                return;
            }

            _selectedIndex = _selectedIndex + n;
            if (_selectedIndex < 0)
            {
                _selectedIndex = 0;
            }
            else if (_selectedIndex >= _list.Length)
            {
                _selectedIndex = _list.Length - 1;
            }
            _isAutoSelect = false;
            _isSelected = true;
            OnUpdated();
        }

        internal void UpdatePosition(Point parentWindowScreenPosition)
        {
            Point pos = Win32.GetCaretPosition();
            _location = new Point(parentWindowScreenPosition.X + pos.X, parentWindowScreenPosition.Y + 20);
            OnUpdated();
        }
        internal bool Visible
        {
            get { return _visible; }
            set
            {
                _visible = value;
                OnUpdated();
            }
        }

    }
}
