﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Editor.Parser.IronPythonParser
{
    class PyToken : IPyExpression, IPyToken
    {
        readonly string _text;
        readonly TokenType _type;
        internal PyToken(string text)
        {
            _text = text;
        }
        internal PyToken(string text, TokenType type)
        {
            _text = text;
            _type = type;
        }
        public string Text
        {
            get { return _text; }
        }
        public TokenType Type
        {
            get { return _type; }
        }

        #region IExpression メンバ

        public string ToText()
        {
            return _text;
        }
        public PyTypeInfo GetTypeInfo(INameResolve resolver)
        {
            string example = "";
            Type type = null;
            KindOfType kindOfType = KindOfType.DotNetVariable;
            if (_type == TokenType.shortstring1 ||
                _type == TokenType.shortstring2 ||
                _type == TokenType.shortstring3 ||
                _type == TokenType.shortstring4 ||
                _type == TokenType.longstring1 ||
                _type == TokenType.longstring2 ||
                _type == TokenType.longstring3 ||
                _type == TokenType.longstring4 ||
                _type == TokenType.longstring5 ||
                _type == TokenType.longstring6)
            {
                example = "\"\"";
                type = typeof(string);
            }
            if (_type == TokenType.floatnumber1 ||
                _type == TokenType.floatnumber2 ||
                _type == TokenType.floatnumber3)
            {
                if (IsImagineNumber(_text))
                {
                    example = "1.5J";
                    kindOfType = KindOfType.PythonVariable;
                }
                else
                {
                    example = "1.5";
                    type = typeof(double);
                }
            }
            if (_type == TokenType.hexinteger ||
                _type == TokenType.integer ||
                _type == TokenType.octinteger)
            {
                if (IsImagineNumber(_text))
                {
                    example = "1J";
                    kindOfType = KindOfType.PythonVariable;
                }
                else
                {
                    example = "1";
                    type = typeof(int);
                }
            }
            if (_type == TokenType.identifier)
            {
                return resolver.GetIdentifier(_text);
            }

            return new PyTypeInfo(type, example, kindOfType);
        }

        private bool IsImagineNumber(string text)
        {
            return text.ToLower().EndsWith("j");
        }

        public string ToOriginalText()
        {
            return _text;
        }


        #endregion

        public override string ToString()
        {
            return "PyToken: " + ToText();
        }


    }
}
