﻿using System;
using System.Collections.Generic;
using System.Text;
using Editor.Parser.IronPythonParser;

namespace Editor.Parser
{
    class ParseResult : IParseResult
    {
        readonly int _curosrIndex;
        readonly PyTokenCollection _tokens;
        readonly IPyExpression _intelisenceExpression;
        readonly IPyExpression _helpExpression;
        readonly PyLexer _lexer;

        internal ParseResult(PyTokenCollection tokens, int curosrIndex, IPyExpression intelisenceExpression, IPyExpression helpExpression, PyLexer lexer)
        {
            if (intelisenceExpression == null)
            {
                intelisenceExpression = new PyExpression(ExpressionType.Empty);
            }
            if (helpExpression == null)
            {
                helpExpression = new PyExpression(ExpressionType.Empty);
            }
            _curosrIndex = curosrIndex;
            _tokens = tokens;
            _intelisenceExpression = intelisenceExpression;
            _helpExpression = helpExpression;
            _lexer = lexer;
        }
        internal bool IsTextContinue
        {
            get
            {
                if (_tokens.Count == 0)
                {
                    return false;
                }
                return IsTextContinueToken(_tokens[_tokens.Count - 1].Type);
            }
        }

        private static bool IsTextContinueToken(TokenType tokenType)
        {
            return tokenType == TokenType.longstring3 || tokenType == TokenType.longstring4;
        }
        internal IPyExpression IntelisenceExpression
        {
            get { return _intelisenceExpression; }
        }
        internal IPyExpression HelpExpression
        {
            get { return _helpExpression; }
        }
        #region IParseResult メンバ

        public bool IsShowHelp
        {
            get
            {
                return _helpExpression.ToOriginalText() != "";
            }
        }

        public bool IsShowIntelisence()
        {
            return _intelisenceExpression.ToOriginalText() != "" || GetWord() != "";
            //return _tokens.CreateWithoutWhiteSpace().Count != 0;
        }

        public string GetWord()
        {
            PyToken token = _tokens.GetTokenAt(_curosrIndex -1);
            if (token == null)
            {
                return "";
            }
            if (token.Type == TokenType.identifier || token.Type == TokenType.integer)
            {
                return token.Text;
            }
            return "";
        }

        public string Text
        {
            get
            {
                return _tokens.GetOriginalText();
            }
        }

        public int Replace(string selectedItem)
        {
            if (_lexer == null)
            {
                return 0;
            }
            PyTokenCollection tokens = _lexer.Lex(selectedItem);
            
            PyToken token = tokens[0];
            if (_tokens.Count == 0)
            {
                _tokens.Add(token);
                return _tokens.GetLength();
            }

            int indexOfToken;
            PyToken currentToken = _tokens.GetTokenAt(_curosrIndex, out indexOfToken);
            if (currentToken == null)
            {
                //カーソルが最後なら
                PyToken lastToken = _tokens.GetTokenAt(_curosrIndex - 1, out indexOfToken);
                if (lastToken.Type == TokenType.identifier)
                {
                    //直前がidentifierなら置換
                    //AA.AA|
                    _tokens[_tokens.Count - 1] = token;
                }
                else
                {
                    //直前がidentifier以外なら追加
                    //AA.|
                    _tokens.Add(token);
                }
            }
            else
            {
                //カーソルが途中なら
                if (indexOfToken == 0)
                {
                    //カーソルがidentifierの先頭なら
                    //AA.|AA
                    if (selectedItem.StartsWith(currentToken.Text))
                    {
                        //入力文字と現在文字が同じなら置換
                        int tokenIndex = _tokens.IndexOf(currentToken);
                        _tokens[tokenIndex] = token;
                    }
                    else
                    {
                        //入力文字と現在文字が違うなら挿入
                        int tokenIndex = _tokens.IndexOf(currentToken);
                        _tokens.Insert(tokenIndex, token);
                    }
                }
                else
                {
                    //カーソルがidentifierの途中なら置換
                    //AA.A|A
                    int tokenIndex = _tokens.IndexOf(currentToken);
                    _tokens[tokenIndex] = token;
                }
            }
            return _tokens.GetLength();
        }

        #endregion

        internal PyTokenCollection Tokens
        {
            get { return _tokens; }
        }
    }
}
