﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;

namespace Editor
{
    static class TypeNameService
    {
        static Regex genericRegex = new Regex("(.+)`[0-9]+");
        internal static string ToSimpleTypeName(Type type)
        {
            if (genericRegex.IsMatch(type.Name))
            {
                return genericRegex.Replace(type.Name, "$1");
            }
            return type.Name;
        }
        internal static string ToSimpleTypeName(string name)
        {
            if (genericRegex.IsMatch(name))
            {
                return genericRegex.Replace(name, "$1");
            }
            return name;
        }
    }
}
